/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 * mapping between clock numbers and names
 * saved data about clocks between runs
 */

/* CLOCK_STATE - data about clocks */

extern int clock_n;
#define CLOCK_MAX() (clock_n - 1) /* index of highest clock */

#define CLOCKLEN 32

typedef struct clock_state_s
{
  char name[CLOCKLEN];

  /* FROM CLOCK_CONFIG FILE */
  short flags;			/* use in integrated, don't write, etc */

  /* FROM CLOCK_STATE FILE */
  ntp_t begin;			/* beginning of last fit (NTP time) */
  ntp_t end;			/* end of last fit (NTP time) */
  ntp_t newbegin;		/* earlier beginning (NTP time) */
  short count;			/* count of # times newbegin calculated */
  char valid;			/* if read from file */

  char offset_valid;		/* offset read from state file */
  real_t offset;		/* systematic offset */

  /* GENERATED DURING THIS RUN */
  real_t low_delay, high_delay;
  real_t base_delay, add_delay, mul_delay;
} clock_state_t;

/* values for clock_state_t flags */
#define CLOCK_USE_INTEGRATED 1	/* try to use in integrated - user spec */
#define CLOCK_OMIT 2		/* don't output or compute param */
#define CLOCK_VALID_INTEGRATED 0x10 /* ok --- quality check */
#define CLOCK_INTEGRATED_MASK (CLOCK_USE_INTEGRATED | CLOCK_VALID_INTEGRATED)

extern clock_state_t clock_state[NCLOCKS];

/* values for pseudo-datasets  */
#define CLOCK_NTP -1
#define CLOCK_ALL -2
#define CLOCK_ALLRAW -3
#define CLOCK_ALLVALID -4

extern dataset_t ntploop;		/* ntp local clock logs */
extern dataset_t raw[NCLOCKS];		/* raw aoffset observations */
extern dataset_t *ntpp;

int clock_parse(char *s);	/* convert string to int */

/* convert number to string */
#ifdef __GNUC__
inline static
#endif
char *
clock_unparse(int n)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  if ( n == CLOCK_NTP )
    return "NTP";
  else
    return clock_state[n].name;
}
#else
;
#endif

#ifdef __GNUC__
inline static
#endif
dataset_t *
clock2dataset(int clock)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  if ( clock == CLOCK_NTP )
    return ntpp;
  if ( clock > CLOCK_NTP && clock <= CLOCK_MAX() )
    return &raw[clock];
  panic("clock2dataset: bad clock value");
  return NULL;
}
#else
;
#endif

void clock_config(FILE *fin, FILE *flog);
void clock_state_print(FILE *finfo, int cl);
void clock_state_read(FILE *fin, FILE *flog);
void clock_state_write(FILE *fout, FILE *flog);
void clock_state_makevalid(FILE *finfo);

void Invalid_adjweight(FILE *finfo, int clock, double frac);
void sdev_adjweight(FILE *finfo, int clock, double sdev);

