/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 */

#include "pd.h"

struct autocorr_s
{
  double sum;
  double n;
};
typedef struct autocorr_s autocorr_t;

#define BINSIZE 1800
#define AUTOCORR_BIN(diff) ( ((diff) + ((BINSIZE>>1) - 1)) / BINSIZE )

void
Autocorr_segment(FILE *finfo, segment_t *sp, int rsadjn)
{
  ntp_t begin, end;
  int first, last;

  autocorr_t *data;
  int nbins, bin;
  double variance, mean;
  int variancen;
  int i, j;
  datapoint_t *pi, *pj;

  if ( sp == NULL )
    {
      fprintf(stderr, "NULL SP to autocorr\n");
      return;
    }

  first = segment_begin(sp);
  begin = segment_begin_time(sp);
  last = segment_end(sp, 1);
  end = segment_end_time(sp, 1);

  nbins = AUTOCORR_BIN(end - begin);
  nbins++;

  fprintf(finfo, "n = %i to %i   t = %u to %u   nbins = %d\n",
	  first, last, begin, end, nbins);

  data = malloc(nbins * sizeof(autocorr_t));
  if ( data == NULL )
    panic("malloc for autocorrelation");
  bzero(data, nbins * sizeof(autocorr_t));
  variance = mean = 0;
  variancen = 0;

  for ( i = first; i <= last ; i++ )
    if ( sp->ds->dptr[i].valid == VALID_OK )
      {
	pi = & sp->ds->dptr[i];
	mean +=  pi->poffset[rsadjn];
	variance += pi->poffset[rsadjn] * pi->poffset[rsadjn];
	variancen++;
	for ( j = i+1; j <= last; j++ )
	  if ( sp->ds->dptr[j].valid == VALID_OK )
	    {
	      pj = & sp->ds->dptr[j];

	      bin = AUTOCORR_BIN( pj->time - pi->time );
	      if ( bin < 0 || bin > nbins )
		panic("AUTOCORR_BIN 1");
	      data[bin].sum += pi->poffset[rsadjn] * pj->poffset[rsadjn];
	      data[bin].n ++;
	    }
      }

  /* no points */
  if ( variancen < 1 )
    goto OUT;
  variance /= variancen;
  mean /= variancen;

  fprintf(finfo, "Variance = %10.6f (10^6 s^2)\nmean = %g\n",
	  variance * 1000000.0, mean);

  fprintf(finfo, "BIN\ttime\tn\tvalue (variance)\n");
  for ( i = 0; i < nbins; i++ )
    if ( data[i].n >= 1.0 )
      fprintf(finfo, "%d\t%3.1f\t%d\t%10.6f\n",
	      i, i * BINSIZE/3600.0, (int) data[i].n,
	      (data[i].sum / data[i].n) / variance);

 OUT:
  free(data);
}
