%
% Compare clock filter (usno) and raw (usno_raw) data.
%
load usno.txt;
load usno_raw.txt;
loglog(usno(1,:), usno(2,:) * 1e6, 'w-', usno_raw(1,:), usno_raw(2,:) * 1e6, 'w--')
set(gca, 'FontSize', 16)
h = text(usno(1,1), usno(2,1) * 1e6, 'USNO');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(usno_raw(1,1), usno_raw(2,1) * 1e6, 'USNO (raw)');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
ylabel('Allan Deviation (PPM)');
xlabel('Time Interval (s)');
print -deps comp_usno;
print -dgif8 comp_usno;
%
% Compare real and synthetic Allan deviation for peer sources.
%
load barn.txt;
load synth_barn.txt;
load peers.txt;
load synth_peers.txt;
load usno.txt;
load synth_usno.txt;
load ien.txt;
load synth_ien.txt;
load usno_raw.txt;
load synth_usno_raw.txt;
loglog(barn(1,:), barn(2,:) * 1e6, 'w-', ...
synth_barn(1,6:length(synth_barn)), synth_barn(2,6:length(synth_barn)) * 1e6, 'w--', ...
peers(1,:), peers(2,:) * 1e6, 'w-', ...
synth_peers(1,6:length(synth_peers)), synth_peers(2,6:length(synth_peers)) * 1e6, 'w--', ...
usno(1,:), usno(2,:) * 1e6, 'w-', ...
synth_usno(1,6:length(synth_usno)), synth_usno(2,6:length(synth_usno)) * 1e6, 'w--', ...
ien(1,:), ien(2,:) * 1e6, 'w-', ...
synth_ien(1,6:length(synth_ien)), synth_ien(2,6:length(synth_ien)) * 1e6, 'w--', ...
usno_raw(1,:), usno_raw(2,:) * 1e6, 'w-', ...
synth_usno_raw(1,6:length(synth_usno_raw)), synth_usno_raw(2,6:length(synth_usno_raw)) * 1e6, 'w--')
set(gca, 'FontSize', 16)
h = text(barn(1,1), barn(2,1) * 1e6, 'BARN');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(peers(1,1), peers(2,1) * 1e6, 'PEERS');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(usno(1,1), usno(2,1) * 1e6, 'USNO');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'right');
h = text(ien(1,1), ien(2,1) * 1e6, 'IEN');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(usno_raw(1,1), usno_raw(2,1) * 1e6, 'USNO (raw)');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
ylabel('Allan Deviation (PPM)');
xlabel('Time Interval (s)');
print -deps comp_barn;
print -dgif8 comp_barn;
%
% Compare real and synthetic Allan deviation for pps/lan sources.
%
load synth_noise.txt;
load pps.txt;
load synth_pps.txt;
load lan.txt;
load synth_lan.txt;
loglog(synth_noise(1,:), synth_noise(2,:) * 1e6, 'w--', pps(1,:), pps(2,:) * 1e6, 'w-', synth_pps(1,:), synth_pps(2,:) * 1e6, 'w--', lan(1,:), lan(2,:) * 1e6, 'w-', synth_lan(1,:), synth_lan(2,:) * 1e6, 'w--')
set(gca, 'FontSize', 16)
h = text(synth_noise(1,1), synth_noise(2,1) * 1e6, 'NOISE');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'left');
h = text(synth_pps(1,1), synth_pps(2,1) * 1e6, 'PPS');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'left');
h = text(synth_lan(1,1), synth_lan(2,1) * 1e6, 'LAN');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'left');
ylabel('Allan Deviation (PPM)');
xlabel('Time Interval (s)');
print -deps comp_pps;
print -dgif8 comp_pps;
