% Read raw data and construct Allan variance from data file.
% Data are collected using rawstats and NTP simulator.
% Only peer included is lan.
%
% Extract/filter real data.
%
clear;
fid = fopen('lan', 'r');
[table, count] = fscanf(fid, '%f %f %f %f %f');
x1 = table(1:5:count) * 86400 + table(2:5:count);
x1 = x1 - x1(1);
y1 = table(3:5:count) * 1000000;
x = x1; y = y1;
%
% Fix rollover and occasional tick interrupt and a spike or two.
%
d = 0;
for i = 2:length(x)
        if ((y1(i - 1) - y1(i)) > 500000)
                d = d + 1000000;
        elseif ((y1(i - 1) - y1(i)) < -500000)
                d = d - 1000000;
        end
        y(i) = y1(i) + d;
        if ((y(i - 1) - y(i)) > 5000)
                y(i) = y(i) + 10000;
        end
end
y1 = decimate(y, 4);
unix('rm -f ./freq_lan');
for i = 1:length(y1) - 99 
        u = sort(diff(y1(i:i + 99) / 64));
        y2(i) = mean(u(25:76));
	fprintf('freq_lan', '%.0f %.3f\n', 64 * i, y2(i));
end
day = (1:length(y2)) * 64 / 86400;
plot(day, y2);
set(gca, 'FontSize', 16)
axis([0 16 -4 1]);
ylabel('Frequency (PPM)');
xlabel('Time (day)');
print -deps freq_lan;
print -dgif8 freq_lan;
