%
% dependencies
%
noise;
pps;
lan;
barn;
peers;
usno;
ien;
usno_raw;
test;
%
% allan intercept data
%
load pps.txt;
f = pps(2,6);
g = 6.5e-6 / f;
sprintf('pps %d %.2e %.2e\n', pps(1,6), f * 1e6, g * f)
load lan.txt;
f = lan(2,3);
sprintf('lan %d %.2e %.2e\n', lan(1,3), f * 1e6, g * f)
load barn.txt;
f = barn(2,1);
sprintf('barn %d %.2e %.2e\n', barn(1,1), f * 1e6, g * f)
load peers.txt;
f = peers(2,1);
sprintf('peers %d %.2e %.2e\n', peers(1,1), f * 1e6, g * f)
load usno.txt;
f = usno(2,1);
sprintf('usno %d %.2e %.2e\n', usno(1,1), f * 1e6, g * f)
load ien.txt;
f = ien(2,1);
sprintf('ien %d %.2e %.2e\n', ien(1,1), f * 1e6, g * f)
load usno_raw.txt;
f = usno_raw(2,1);
sprintf('usno_raw %d %.2e %.2e\n', usno_raw(1,1), f * 1e6, g * f)
load synth_noise.txt;
f = synth_noise(2,6);
sprintf('synth_noise %d %.2e %.2e\n', synth_noise(1,6), f * 1e6, g * f)
%
% Plot allan deviation characteristics
%
loglog(synth_noise(1,:), synth_noise(2,:) * 1e6, 'w--', pps(1,:), pps(2,:) * 1e6, 'w-', lan(1,:), lan(2,:) * 1e6, 'w-', peers(1,:), peers(2,:) * 1e6, 'w-', barn(1,:), barn(2,:) * 1e6, 'w-', usno(1,:), usno(2,:) * 1e6, 'w-', ien(1,:), ien(2,:) * 1e6, 'w-');
set(gca, 'FontSize', 16)
axis([1 1e5 1e-3 1e3]);
h = text(synth_noise(1,1), synth_noise(2,1) * 1e6, 'NOISE');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'left');
h = text(pps(1,1), pps(2,1) * 1e6, 'PPS');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'left');
h = text(lan(1,1), lan(2,1) * 1e6, 'LAN');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(barn(1,1), barn(2,1) * 1e6, 'BARN');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(peers(1,1), peers(2,1) * 1e6, 'PEERS');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
h = text(usno(1,1), usno(2,1) * 1e6, 'USNO');
set(h, 'VerticalAlignment', 'baseline');
set(h, 'HorizontalAlignment', 'right');
h = text(ien(1,1), ien(2,1) * 1e6, 'IEN');
set(h, 'VerticalAlignment', 'middle');
set(h, 'HorizontalAlignment', 'right');
ylabel('Allan Deviation (PPM)');
xlabel('Time Interval (s)');
print -deps allan;
print -dgif8 allan;
%
% Make frequency data file for simulator
%
pps_freq;
lan_freq;
