/*
 * Copyright (c) 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: setproctitle.c,v 1.2 97/06/26 20:17:45 leres Exp $ (LBL)";
#endif

/*
 * setproctitle - overwrite the argv so ps will show what we're doing
 */

#include <sys/types.h>
#ifdef HAVE_SYS_PSTAT_H
#include <sys/pstat.h>
#endif

#include <stdio.h>
#include <string.h>

#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "setproctitle.h"
#include "util.h"

static char *titlestart;
static char *titleend;
static char *progname;

extern char *__progname;

void
initproctitle(int argc, char **argv)
{
	register char *cp;

	titlestart = argv[0];
	cp = argv[argc - 1];
	titleend = cp + strlen(cp);
	progname = savestr(__progname);
}

void
setproctitle(const char *fmt, ...)
{
	va_list ap;
	register char *cp;
	char buf[1024];
#ifdef HAVE_PSTAT
	union pstun pstun;
#else
	register const char *cp2;
#endif

#if __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	cp = buf;
	(void)strcpy(cp, progname);
	cp += strlen(cp);
	*cp++ = ' ';
	(void)vsprintf(cp, fmt, ap);
	va_end(ap);

#ifdef HAVE_PSTAT
	/* HPUX */
	pstun.pst_command = buf;
	(void)pstat(PSTAT_SETCMD, pstun, strlen(buf), 0, 0);
#else
	cp = titlestart;
	cp2 = buf;
	while (cp < titleend - 2 && *cp2 != '\0')
		*cp++ = *cp2++;
	*cp++ = '\0';
	while (cp < titleend)
		*cp++ = ' ';
#endif
}
