/*
 * Copyright (c) 1990, 1991, 1992, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: disk.c,v 1.29 97/06/26 21:17:17 leres Exp $ (LBL)";
#endif

/*
 * disk - disk usage routines
 */

#include <sys/param.h>
#include <sys/types.h>
#include <sys/file.h>

#ifdef HAVE_STATVFS
#include <sys/statvfs.h>
#endif

#ifdef HAVE_STATFS
#ifdef HAVE_SYS_VFS_H
#include <sys/vfs.h>
#endif
#ifdef HAVE_SYS_STATFS_H
#include <sys/statfs.h>
#endif
#ifdef HAVE_SYS_MOUNT_H
#include <sys/mount.h>
#endif
#endif

#include <errno.h>
#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <string.h>

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include <err.h>

#include "dexpire.h"
#include "disk.h"

/*
 * Convert statfs returned filesystem size into BLOCKSIZE units.
 * Attempts to avoid overflow for large filesystems.
 * (From the 4.4BSD-lite df)
 */
#define fsbtoblk(num, fsbs, bs) \
	(((fsbs) != 0 && (fsbs) < (bs)) ? \
		(num) / ((bs) / (fsbs)) : (num) * ((fsbs) / (bs)))


/* Returns free space of specified filesystem in Kbytes */
int
disk_usage(register char *fs, register long *usedp,
    register long *freep, register long *inodep, register long *ifreep)
{
#ifdef HAVE_STATVFS
	struct statvfs vsb;
#endif
#ifdef HAVE_STATFS
	struct statfs fsb;
#endif

	errno = 0;
#ifdef HAVE_STATVFS
	memset(&vsb, 0, sizeof(vsb));
	if (statvfs(fs, &vsb) >= 0) {
		/* Return the stats (unknown values are set to -1) */
		if (vsb.f_blocks < 0 || vsb.f_bfree < 0)
			*usedp = -1;
		else
			*usedp = fsbtoblk(vsb.f_blocks - vsb.f_bfree,
			    vsb.f_frsize, 1024);
		*freep = fsbtoblk(vsb.f_bavail, vsb.f_frsize, 1024);
		if (vsb.f_files < 0 || vsb.f_ffree < 0) {
			*inodep = -1;
			*ifreep = -1;
		} else {
			*inodep = vsb.f_files - vsb.f_ffree;
			if (*inodep <= 0)
				*inodep = -1;
			*ifreep = vsb.f_ffree;
		}
		return (0);
	}
#endif
#ifdef HAVE_STATFS
	memset(&fsb, 0, sizeof(fsb));
	if (statfs(fs, &fsb) >= 0) {
#ifdef STATFS_HAS_F_SPARE
		/* XXX Try to undo horrible SunOS 4 kernel hack */
#ifndef INT_MAX
#define INT_MAX 0x7fffffff
#endif
#ifndef MIN
#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#endif
		if (fsb.f_blocks == MIN(fsb.f_spare[0], INT_MAX / fsb.f_bsize))
			fsb.f_blocks = fsb.f_spare[0];
		if (fsb.f_bfree == MIN(fsb.f_spare[1], INT_MAX / fsb.f_bsize))
			fsb.f_bfree = fsb.f_spare[1];
		if (fsb.f_bavail == MIN(fsb.f_spare[2], INT_MAX / fsb.f_bsize))
			fsb.f_bavail = fsb.f_spare[2];
#endif

		/* Return the stats (unknown values are set to -1) */
		if (fsb.f_blocks < 0 || fsb.f_bfree < 0)
			*usedp = -1;
		else
			*usedp = fsbtoblk(fsb.f_blocks - fsb.f_bfree,
			    fsb.f_bsize, 1024);
		*freep = fsbtoblk(fsb.f_bavail, fsb.f_bsize, 1024);
		if (fsb.f_files < 0 || fsb.f_ffree < 0) {
			*inodep = -1;
			*ifreep = -1;
		} else {
			*inodep = fsb.f_files - fsb.f_ffree;
			if (*inodep <= 0)
				*inodep = -1;
			*ifreep = fsb.f_ffree;
		}
		return (0);
	}
#endif
	if (errno == 0)
		errx(1, "disk_usage() unimmplemented");
	return (-1);
}
