;#
;#      @(#)$Id: grep.pl,v 2.1 1993/05/23 23:48:01 sanders Exp $
;#
;# flexible grep
;#
;# Author:  Tony Sanders
;# Usage:   &grep($matched, flags, pattern, FILEHANDLE);
;#              $matched   : function to call on match
;#              flags      : options, see below
;#              pattern    : a regexp to match
;#              FILEHANDLE : an opened FILEHANDLE to read from
;#
;#          $matched can access $_ which is the data matched
;#          if $matched returns true the grep is aborted.
;#
;# Example: create an array entry in @matched for each paragraph that matches
;#	    open(GREP, 'filename') || die "filename: $!";
;#	    &grep('grok', 'pi', $ARGV[0], *GREP) && die $@;
;#	    close(GREP);
;#	    $, = "\n"; 
;#	    foreach $para (@matched)
;#		{ @lines = split(/\n/, $para); print @lines, "\n"; }
;#	    sub grok { push(@matched, $_); 0; }

sub grep {
    local($matched, $flags, $pat, *FH, $_) = @_;
    local($iflag) = ($flags =~ /i/) ? 'i' : '';		# i = ignore case
    local($vflag) = ($flags =~ /v/) ? 'unless' : 'if';	# v = reverse
    local($*, $/) = (1, '') if ($flags =~ /p/);		# p = paragraph mode
    $grep = "GREP: while (<FH>) {
	$vflag (m\377$pat\377$iflag) { last GREP if &$matched; } }";
    eval $grep;
    return $@;
}

1;
