# bsdi-man.pl -- hypertext bsdi man pages
#
# $Id: bsdi-man.pl,v 2.4 1993/07/08 14:21:26 sanders Exp $
#

require "$http_sdir/grep.pl";

package bsdi_man;

# XXX: config options, move to plexus.conf
$man_whatis = "/usr/share/man/whatis.db";
$man_apropos_max = 64;
$man_arch = "i386";
$man_path = $main'ENV{'MANPATH'} || "/usr/share/man:/usr/contrib/man:/usr/X11/man";
@man_path = split(":", $man_path);
@man_sect = ("1","2","3","3C","3X11","4","5","6","7","8","l","n","o");
$man_sectexp = join("|", @man_sect);
$man_index = $main'http_index;		# relative to $mantop
$man_hdr = "hdr.html";			# relative to $mantop
$man_ftr = "ftr.html";			# relative to $mantop

sub main'do_bsdi_man {
    local($mantop, $path, $query) = @_;
    $query = $path unless $query;
    return &main'retrieve("$mantop/$man_index") unless $query;
    local($name, $sect) = $query =~ m/^([^()]*)\(([^)]*)\)/;
    return &fetch_man($name, $sect) if $name;
    &apropos($query);
}

sub apropos_grok {
    # matches whatis.db lines: name[, name ...] (sect) - msg
    local($names, $sect, $msg) = m/^([^()]+)\(([^)]*)\)\s+-\s+(.*)/;
    local($key) = m/^([^,\s]*)/;		# first element only
    print "<DT><A HREF=\"/$mantop/?$key($sect)\">$names($sect)</A>\n<DD>$msg\n";
    unless ($count--) {				# abort search if it gets long
	print "<DT>...search truncated...\n<DD>\n"; return 1;
    }
    return 0;
}

sub apropos {
    local($query) = @_;
    local($count) = $man_apropos_max;
    open(GREP, "< $man_whatis") || &main'error('internal_error', "$man_whatis: $!");
    &main'MIME_header('ok', 'text/html');
    print "<HEAD>\n<ISINDEX>\n<TITLE>BSDI Hypertext Man Pages: Apropos $query</TITLE>\n";
    print "</HEAD>\n<BODY>\n<H1>Apropos: $query</H1>\n";
    print "Back to <A HREF=\"/$mantop/\">Index Page</A>\n<DL>\n";
    $query =~ s/[\377\+\/]+/\\s\*/g;		# protect delimeter
    &main'grep("bsdi_man'apropos_grok", 'i', $query, *GREP) && &main'error('internal_error', $@);
    close(GREP);
    print "</DL>\n</BODY>\n";
}

# XXX: need to cache results or preload the directories
# there are about 2000 man pages (60K data)
sub locate_man {
    local($i, $j);
    foreach $j (@sect) {
        $j =~ s/[xXcC].*//;				# XXX: foo
        foreach $i (@man_path) {
            return $j if open(MAN, "$i/cat$j/$name.0");
	    return $j if open(MAN, "$i/cat$j/$man_arch/$name.0");
	}
    }
    return undef;
}

sub fetch_man {
    local($name, $where) = @_;
    local(@sect, $sect) = $where || @man_sect;
    local($link, $regexp, $match, $foo);

    return &noman unless defined ($sect = &locate_man);

    &main'MIME_header('ok', 'text/html');
    print "<HEAD>\n<ISINDEX>\n";
    print "<TITLE>BSDI Hypertext Man Pages: Fetch $name($sect)</TITLE>\n";
    print "</HEAD>\n<BODY>\n";
    -f "$mantop/$man_hdr" && &main'raw_file("$mantop/$man_hdr");
    print "<PRE>\n";

    while(<MAN>) {
	alarm($main'http_timeout);
	s,((_\010.)+),($foo = $1) =~ s/.\010//g; "\376I\377$foo\376/I\377";,ge;
	s,((.\010.)+),($foo = $1) =~ s/.\010//g; "\376B\377$foo\376/B\377";,ge;
	s/.[\b]//g;			# catch sluff
	s/\&/\&\#38\;/g; s/\</\&\#60\;/g; s/\>/\&\#62\;/g;
	s/\376/</g; s/\377/>/g;		# convert back
	if(m,(<B>)?\#include(</B>)?\s+(<B>)?\&#60\;(.*\.h)\&#62\;(</B>)?,) {
	    $match = $4; ($regexp = $match) =~ s/\./\\\./;
	    s,$regexp,\<A HREF=\"file:/usr/include/$match\"\>$match\</A\>,;
        }
	/^\s/ && 			# skip headers
	    s,((<[IB]>)?[\w\-\.]+\s*(</[IB]>)?\s*\(($man_sectexp)\)),&mlnk($1),oge;
	print;
    }
    close(MAN);
    print "</PRE>\n";
    -f "$mantop/$man_ftr" && &main'raw_file("$mantop/$man_ftr");
    print "</BODY>\n";
}

sub mlnk {
    local($match) = @_;
    ($link = $match) =~ s/[\s]+//g;
    $link =~ s/<\/?[IB]>//g;
    "<A HREF=\"/$mantop/?$link\">$match</A>";
}

sub noman {
    &main'MIME_header('bad_request', 'text/html');
    print "<HEAD>\n<ISINDEX>\n<TITLE>BSDI Hypertext Man Pages: Fetch Failed</TITLE>\n";
    print "</HEAD>\n<BODY>\n<H1>Fetch: $name($where)</H1>\n";
    print "Sorry, no data found...\n</BODY>\n";
}

1;
