static char rcsid[] = "urld_queue.c,v 1.11 1996/01/04 04:14:45 duane Exp";
/* 
 *  urld_queue.c - Just plain queue manipulation functions...simple stuff
 *
 *  David Merkel, University of Colorado - Boulder, July 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include "urld.h"
#include "util.h"

static int qError = NO_QERROR;

int GetQErr()
{
	return (qError);
}


/*
 * InitQueue() - Initializes queue header block and returns
 * pointer to caller
 */
Queue *InitQueue(maxConnect)
     int maxConnect;
{
	Queue *theQueue = (Queue *) malloc(sizeof(Queue));

	if (!theQueue) {
		qError = CANT_MALLOC_Q;
		return (NULL);
	}
	theQueue->maxConnect = maxConnect;
	theQueue->qLength = 0;
	theQueue->head = NULL;
	theQueue->tail = NULL;

	qError = NO_QERROR;
	return (theQueue);
}


/*
 * InitQNode() - Initializes a queue node and returns pointer to caller
 */
QNode *InitQNode(theSocket)
     int theSocket;
{
	QNode *theNode = (QNode *) malloc(sizeof(QNode));

	if (!theNode) {
		qError = CANT_MALLOC_QNODE;
		return (NULL);
	}
	theNode->theSocket = theSocket;
	theNode->next = NULL;
	theNode->prev = NULL;

	qError = NO_QERROR;
	return (theNode);
}


/* 
 * Dequeue() - Dequeues theNode from theQueue and returns pointer to
 * caller
 */
QNode *Dequeue(theQueue, theNode)
     Queue *theQueue;
     QNode *theNode;
{
	QNode *tempPtr = theNode;

	/* just dequeue theNode and return to caller,
	 * we return to caller so caller may use net to notify
	 * client of dequeue, want to isolate net functions outside
	 * of queue code
	 */

	if (!theNode)
		tempPtr = theQueue->tail;

	/* if theNode is in middle of queue somewhere */
	if (theQueue->head == tempPtr)
		theQueue->head = tempPtr->next;
	if (theQueue->tail == tempPtr)
		theQueue->tail = tempPtr->prev;
	if (tempPtr->prev)
		tempPtr->prev->next = tempPtr->next;
	if (tempPtr->next)
		tempPtr->next->prev = tempPtr->prev;

	tempPtr->prev = NULL;
	tempPtr->next = NULL;
	theQueue->qLength--;
	qError = NO_QERROR;
	return (tempPtr);
}


/* 
 * Enqueue() - enqueues theNode into theQueue.  If this forces queue
 * to expand beyond max number of entries then one node last in queue
 * (least recent used) is dequeued and a pointer to it returned to
 * caller.
 */
QNode *Enqueue(theQueue, theNode)
     Queue *theQueue;
     QNode *theNode;
{
	QNode *tempPtr, *dqPtr = NULL;

	tempPtr = theQueue->head;

	/* empty queue */
	if (!tempPtr) {
		theQueue->head = theNode;
		theQueue->tail = theNode;
		theQueue->qLength++;
		qError = NO_QERROR;
		return (NULL);
	}
	/* new connect will violate max connects allowed */
	if ((theQueue->qLength + 1) > (theQueue->maxConnect)) {
		if (!(dqPtr = Dequeue(theQueue, NULL))) {
			qError = DEQ_ERROR;
			return (NULL);
		}
	}
	theQueue->head = theNode;
	theNode->next = tempPtr;
	tempPtr->prev = theNode;

	/* dequeued oldest connect to make room for new one */
	if (dqPtr)
		qError = DEQ_ON_ENQ;
	else
		qError = NO_QERROR;

	theQueue->qLength++;
	return (dqPtr);
}


/* 
 * DestroyQueue() - deallocates all nodes in Q and theQueue itself
 */
void DestroyQueue(theQueue)
     Queue *theQueue;
{
	QNode *tempPtr;
	while (theQueue->head) {
		tempPtr = Dequeue(theQueue, theQueue->tail);
		if (tempPtr)
			free(tempPtr);
	}
	free(theQueue);
	qError = NO_QERROR;
}
