/*
 *  data_object.h - Data object support for Essence
 *  data_object.h,v 1.11 1995/09/05 19:11:27 hardy Exp
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#ifndef _DATA_OBJECT_H
#define _DATA_OBJECT_H

#include <sys/stat.h>
#include "util.h"
#include "url.h"
#include "template.h"

#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus) || defined(__STRICT_ANSI__)
#define _PARAMS(ARGS) ARGS
#else /* Traditional C */     
#define _PARAMS(ARGS) ()      
#endif /* __STDC__ */              
#endif /* _PARAMS */   

struct data_object {
	URL *url;		/* Object's URL */
	char *type;		/* Object's Type */
	char *data;		/* Contents of the object */
	int dsize;		/* Current size of the data pointer */
	unsigned int flags;	/* Flags about the object */
	char *parent_url;	/* Parent URL if nested file */
	char *ttype;		/* Template Type */
	AVList *avl;		/* Some Attribute-Value pairs */

/* For file objects */
	char *basename;		/* Basename of the filename */
	struct stat *s;		/* Statistics about the object */
};

struct data_object_list {
	struct data_object      *object;	/* object itself */
	struct data_object_list *next;		/* link */
};

typedef struct data_object      DataObject;
typedef struct data_object_list DataObjectList;

/*
 *  Flag values for create_data_object()
 */
#define F_NO_ACCESS	0x0001		/* Forbid read() access to object */
#define F_TEMPORARY	0x0002		/* object is temporary */
#define F_NESTED	0x0004		/* object is nested */
#define F_MANUAL	0x0008		/* object is manual only */


/* Functions */
DataObject *create_data_object _PARAMS((char *, unsigned int));
DataObjectList *create_dol _PARAMS((char *, unsigned int));
int object_retrieve _PARAMS((DataObject *));
void free_data_object _PARAMS((DataObject *));
void free_dol _PARAMS((DataObjectList *));

#endif /* _DATA_OBJECT_H */
