static char rcsid[] = "brkclient.c,v 1.11 1996/01/04 04:07:01 duane Exp";
/*
 *  brkclient - Very simple client program for the Broker interface
 *
 *  Usage: brkclient hostname port command-string
 *
 *  For example,
 *
 *      brkclient localhost 8501 '#USER #END fun AND sun'
 *
 *  Darren Hardy, hardy@cs.colorado.edu, September 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <locale.h>

static void sigdie()
{
	_exit(1);
}

int main(argc, argv)
     int argc;
     char *argv[];
{
	struct hostent *hp;
	struct sockaddr_in sa;
	FILE *ifp;
	int s, n, port;
	char *host, *cmdstr, buf[BUFSIZ];

	(void) setlocale(LC_ALL, "");

	signal(SIGALRM, sigdie);
	alarm(0);
	if (argc != 4) {
		fprintf(stderr,
		    "Usage: brkclient hostname port command-string\n");
		exit(1);
	}
	host = argv[1];
	port = atoi(argv[2]);
	cmdstr = argv[3];

	/* Find out who they are */
	if ((hp = gethostbyname(host)) == NULL) {
		if (errno == 0)
			fprintf(stderr, "%s: Host unknown.\n", host);
		else
			perror(host);
		exit(1);
	}
	/* Set up the Destination Address */
	memcpy(&sa.sin_addr, hp->h_addr, hp->h_length);
	sa.sin_family = AF_INET;
	sa.sin_port = (unsigned short) htons(port);

	/* Create a socket, and connect to the remote host */
	if ((s = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
		perror("socket");
		exit(1);
	}
	if (connect(s, (struct sockaddr *) &sa, sizeof(sa)) < 0) {
		perror("connect");
		exit(1);
	}
	if (write(s, cmdstr, strlen(cmdstr)) < 0) {
		perror("write");
		exit(1);
	}
	if ((ifp = fdopen(s, "r")) == NULL) {
		perror("fdopen");
		exit(1);
	}
	alarm(600);		/* give 10 minutes to read the next data */
	while ((n = fread(buf, 1, BUFSIZ, ifp)) > 0) {
		alarm(600);
		fwrite(buf, 1, n, stdout);
	}
	alarm(0);
	fclose(ifp);
	exit(0);
}
