#!/bin/sh
#
#  make-symlinks.sh - Creates symbolic links for some common programs 
#  into $HARVEST_HOME/bin
#
#  Usage: make-symlinks.sh [HARVEST_HOME]
#
#  make-symlinks.sh,v 1.7 1995/11/17 06:39:07 duane Exp
#
PATH=${PATH}:/usr/bsd:/usr/ucb:/usr/local/bin:/bin:/usr/bin; export PATH

debug=:
#debug=echo

if test -n "$1"; then
	HARVEST_HOME=$1; export HARVEST_HOME
fi
if test -z "$HARVEST_HOME"; then
	echo "You must set \$HARVEST_HOME or give it as an argument"
	exit 1
fi
if test ! -d "$HARVEST_HOME/bin"; then
	echo "$HARVEST_HOME/bin is not a directory."
	exit 1
fi
if test ! -w "$HARVEST_HOME/bin"; then
	echo "Directory $HARVEST_HOME/bin is not writable"
	exit 1
fi

progs='gzip hostname whoami perl'
pathdirs=`echo $PATH \
  | sed -e 's/^:/:.:/g' -e 's/:$/:.:/g' -e 's/::/:.:/g' -e 's/:/ /g'`

for p in $progs; do

	link="${HARVEST_HOME}/bin/${p}"

	# See if $link exists already.  If its a symlink, nuke it.
	#
	if [ "`find $link -type l -print 2>/dev/null`" = "$link" ]; then
		$debug "$link is a symbolic link, removing"
		rm -f $link
	fi

	for d in $pathdirs; do
		if expr "$d" : "$HARVEST_HOME" >/dev/null; then	# skip
			continue				# HARVEST_HOME
		fi						# directories
		if expr "$d" : "/usr/local/harvest" >/dev/null; then	# skip
			continue				# HARVEST_HOME
		fi						# directories
		exe="${d}/${p}"
		$debug "check $exe"
		if [ -x "$exe" -a -f "$exe" ]; then
			echo Creating a symbolic link for $exe into $link
			#
			#  We cannot use 'test -h $link' because -h is
			#  not portable.  -e is also not portable.
			#  Use -r since it's the most portable.
			#
			if [ ! -r "$link" ]; then
				ln -s $exe $link
			else
				echo "WARNING: Cannot create $link since $exe is already exists."
			fi
			break
		fi
	done
done
