/*
 *  extern.h - Extern vars for Essence
 *
 *  extern.h,v 1.21 1995/09/05 19:11:30 hardy Exp
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#ifndef _EXTERN_H_
#define _EXTERN_H_

#undef GLOBAL
#ifdef MAIN 			/* Global variables */
#define GLOBAL
#else
#define GLOBAL extern
#endif

GLOBAL int verbose;		/* verbose output? */
GLOBAL int do_keywords;		/* automatically generate keywords? */
GLOBAL int do_dupremove;	/* remove duplicates during explode */
GLOBAL int do_fulltext;		/* full-text or summarize? */
GLOBAL int do_fakemd5s;		/* fake MD5s for unnesting? */
GLOBAL int do_typeonly;		/* summarize or not? */
GLOBAL int do_confhost;		/* confirm host or not? */
GLOBAL int do_fast;		/* use fast algos or not */
GLOBAL int do_minimalbooks;	/* minimal bookkeeping or not? */
GLOBAL int max_refresh;		/* max num of objects to refresh */
GLOBAL int memefficient;	/* memory efficient or not? */
GLOBAL int do_cksumdups;	/* check for duplicate attr from summarizer? */
GLOBAL struct GID *gatherer_id;	/* Identification of this gatherer */
GLOBAL char *tmpdir;		/* Temporary directory */
GLOBAL char *stoplist;		/* Stoplist file */
GLOBAL char *allowlist;		/* Allow-only list */
GLOBAL char *topdir;		/* Directory where program was executed */
GLOBAL int default_ttl;		/* default for summary time-to-live value */
GLOBAL int default_refresh;	/* default for summary refresh-rate value */

#ifdef USE_QUICKSUM
GLOBAL char *quicksum_file;	/* Internal Quicksum config */
#endif

#undef GLOBAL

#endif /* _EXTERN_H_ */
