static char rcsid[] = "gdbmutil.c,v 1.8 1996/01/04 03:46:54 duane Exp";
/*
 *  gdbmutil - Master GDBM tool that will perform various tasks on
 *             GDBM files.
 *
 *  Usage: gdbmutil consolidate [-d | -D] master-file file [file ...]
 *         gdbmutil delete file key
 *         gdbmutil dump file
 *         gdbmutil fetch file key
 *         gdbmutil keys file
 *         gdbmutil print [-gatherd] file
 *         gdbmutil reorganize file
 *         gdbmutil restore file
 *         gdbmutil sort file
 *         gdbmutil stats file
 *         gdbmutil store file key < data
 *
 *  Darren Hardy, hardy@cs.colorado.edu, January 1995
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <gdbm.h>
#include "util.h"

int usage()
{
	fprintf(stderr, "\n\
Usage: gdbmutil consolidate [-d | -D] master-file file [file ...]\n\
       gdbmutil delete file key\n\
       gdbmutil dump file\n\
       gdbmutil fetch file key\n\
       gdbmutil keys file\n\
       gdbmutil print [-gatherd] file\n\
       gdbmutil reorganize file\n\
       gdbmutil restore file\n\
       gdbmutil sort file\n\
       gdbmutil stats file\n\
       gdbmutil store file key < data\n\n");
	exit(1);
}

extern int do_consolidate(), do_delete(), do_dump(), do_fetch(), do_keys(),
    do_print(), do_reorganize(), do_restore(), do_sort(), do_stats(), do_store();

struct _gdbm_fun {
	char *name;
	int (*f) ();
} gdbm_funs[] = {

	{
		"consolidate", do_consolidate
	},
	{
		"delete", do_delete
	},
	{
		"dump", do_dump
	},
	{
		"fetch", do_fetch
	},
	{
		"keys", do_keys
	},
	{
		"print", do_print
	},
	{
		"reorganize", do_reorganize
	},
	{
		"restore", do_restore
	},
	{
		"sort", do_sort
	},
	{
		"stats", do_stats
	},
	{
		"store", do_store
	},
	{
		NULL, usage
	}
};

int verbose = 0;

int main(argc, argv)
     int argc;
     char *argv[];
{
	int i;

	init_log(stderr, stderr);

	argv++;
	argc--;
	if (argc < 2)
		usage();

	for (i = 0; gdbm_funs[i].name != NULL; i++) {
		if (!strcmp(*argv, gdbm_funs[i].name)) {
			(*gdbm_funs[i].f) (argc, argv);
			exit(0);
		}
	}
	usage();
}
