static char rcsid[] = "gdbmrestore.c,v 1.15 1996/01/04 03:46:51 duane Exp";
/*
 *  gdbmrestore - Writes a GDBM database that was output from gdbmdump
 *
 *  Darren Hardy, hardy@cs.colorado.edu, April 1994
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <gdbm.h>
#include "util.h"

extern int usage();

static char *mapfile;
static GDBM_FILE mapdb;

int do_restore(argc, argv)
     int argc;
     char *argv[];
{
	datum k, d;
	int i;
	char buf[BUFSIZ], c;

	if (argc != 2)
		usage();

	mapfile = argv[1];
	mapdb = gdbm_open(mapfile, 0, GDBM_NEWDB, 0644, NULL);
	if (mapdb == NULL) {
		errorlog("gdbm_open: %s: %s\n", mapfile,
		    gdbm_strerror(gdbm_errno));
		log_errno(mapfile);
		exit(1);
	}
	while (1) {
		/* grab key size and key */
		i = 0;
		while (1) {
			if ((c = getchar()) == '\0')
				break;
			buf[i++] = c;
		}
		buf[i] = '\0';
		k.dsize = atoi(buf);
		k.dptr = xmalloc(k.dsize);
		memset(k.dptr, '\0', k.dsize);
		for (i = 0; i < k.dsize; i++)
			k.dptr[i] = getchar();

		/* grab data size and data */
		i = 0;
		while (1) {
			if ((c = getchar()) == '\0')
				break;
			buf[i++] = c;
		}
		buf[i] = '\0';
		d.dsize = atoi(buf);
		d.dptr = xmalloc(d.dsize);
		memset(d.dptr, '\0', d.dsize);
		for (i = 0; i < d.dsize; i++)
			d.dptr[i] = getchar();

		if (gdbm_store(mapdb, k, d, GDBM_INSERT)) {
			errorlog("gdbm_store: %s: %s: %s\n", k.dptr,
			    mapfile, gdbm_strerror(gdbm_errno));
			gdbm_close(mapdb);
			exit(1);
		}
		xfree(k.dptr);
		xfree(d.dptr);

		if ((buf[0] = getchar()) == EOF)
			break;
		ungetc(buf[0], stdin);
	}
	gdbm_close(mapdb);
	exit(0);
}
