static char rcsid[] = "gifinfo.c,v 1.5 1996/01/17 10:07:38 duane Exp";
/*
 *  gifinfo.c - Extracts information from a GIF file.
 *
 *  Usage: gifinfo [GIF-file]
 *
 *  Outputs flat A/V pairs
 *
 *  DEBUG: 
 *
 *  Richard Hall, rickhall@cs.colorado.edu, April 1995
 *  Duane Wessels, wessels@cs.colorado.edu, November 1995
 *
 *  Portions of this file are adapted from PBMPLUS.
 *  Copyright (c) 1988, 1989 by Patrick J. Naughton
 *  naughton@wind.sun.com
 *
 *  ----------------------------------------------------------------------
 *  Copyright (c) 1994, 1995.  All rights reserved.
 *  
 *    The Harvest software was developed by the Internet Research Task
 *    Force Research Group on Resource Discovery (IRTF-RD):
 *  
 *          Mic Bowman of Transarc Corporation.
 *          Peter Danzig of the University of Southern California.
 *          Darren R. Hardy of the University of Colorado at Boulder.
 *          Udi Manber of the University of Arizona.
 *          Michael F. Schwartz of the University of Colorado at Boulder.
 *          Duane Wessels of the University of Colorado at Boulder.
 *  
 *    This copyright notice applies to software in the Harvest
 *    ``src/'' directory only.  Users should consult the individual
 *    copyright notices in the ``components/'' subdirectories for
 *    copyright information about other software bundled with the
 *    Harvest source code distribution.
 *  
 *  TERMS OF USE
 *    
 *    The Harvest software may be used and re-distributed without
 *    charge, provided that the software origin and research team are
 *    cited in any use of the system.  Most commonly this is
 *    accomplished by including a link to the Harvest Home Page
 *    (http://harvest.cs.colorado.edu/) from the query page of any
 *    Broker you deploy, as well as in the query result pages.  These
 *    links are generated automatically by the standard Broker
 *    software distribution.
 *    
 *    The Harvest software is provided ``as is'', without express or
 *    implied warranty, and with no support nor obligation to assist
 *    in its use, correction, modification or enhancement.  We assume
 *    no liability with respect to the infringement of copyrights,
 *    trade secrets, or any patents, and are not responsible for
 *    consequential damages.  Proper use of the Harvest software is
 *    entirely the responsibility of the user.
 *  
 *  DERIVATIVE WORKS
 *  
 *    Users may make derivative works from the Harvest software, subject 
 *    to the following constraints:
 *  
 *      - You must include the above copyright notice and these 
 *        accompanying paragraphs in all forms of derivative works, 
 *        and any documentation and other materials related to such 
 *        distribution and use acknowledge that the software was 
 *        developed at the above institutions.
 *  
 *      - You must notify IRTF-RD regarding your distribution of 
 *        the derivative work.
 *  
 *      - You must clearly notify users that your are distributing 
 *        a modified version and not the original Harvest software.
 *  
 *      - Any derivative product is also subject to these copyright 
 *        and use restrictions.
 *  
 *    Note that the Harvest software is NOT in the public domain.  We
 *    retain copyright, as specified above.
 *  
 *  HISTORY OF FREE SOFTWARE STATUS
 *  
 *    Originally we required sites to license the software in cases
 *    where they were going to build commercial products/services
 *    around Harvest.  In June 1995 we changed this policy.  We now
 *    allow people to use the core Harvest software (the code found in
 *    the Harvest ``src/'' directory) for free.  We made this change
 *    in the interest of encouraging the widest possible deployment of
 *    the technology.  The Harvest software is really a reference
 *    implementation of a set of protocols and formats, some of which
 *    we intend to standardize.  We encourage commercial
 *    re-implementations of code complying to this set of standards.  
 *  
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "util.h"

#define INTERLACEMASK 0x40
#define LOCALCOLORMAP  0x80

int BitOffset = 0;		/* Bit Offset of next code */
int RWidth = 0;			/* screen dimensions */
int RHeight = 0;
int Width = 0;			/* image dimensions */
int Height = 0;
int LeftOfs;			/* image offset */
int TopOfs = 0;
int BitPixel = 0;		/* Bits per pixel, read from GIF header */
int ColorMapSize = 0;		/* number of colors */
int BitMask = 0;		/* AND mask for data size */
int ColorResolution = 0;
int Background = 0;
int AspectRatio = 0;

int Interlace, HasColormap;

/* PPMS: defined in ppm.h */

char *id87 = "GIF87a";
char *id89 = "GIF89a";

static char *progname = NULL;

static void usage()
{
    fprintf(stderr, "Usage: %s [GIF-file]\n", progname);
    exit(1);
}

int main(argc, argv)
     int argc;
     char *argv[];
{
    int filesize;
    static unsigned char buf[1024];
    static char format[1024];
    struct stat sb;
    int fd;
    char *filename = NULL;
    int notquit;
    unsigned char count;
    unsigned char exttype;

    setbuf(stderr, NULL);
    progname = xstrdup(argv[0]);
    if (argc != 2)
	usage();
    filename = xstrdup(argv[1]);

    if ((fd = open(filename, O_RDONLY)) < 0) {
	perror(filename);
	exit(1);
    }
    /* find the size of the file */
    if (stat(filename, &sb) < 0) {
	perror(filename);
	exit(1);
    }
    filesize = sb.st_size;

    if (read(fd, buf, 6) != 6) {
	perror("read");
	exit(1);
    }
    if (strncmp(buf, id87, 6) && strncmp(buf, id89, 6)) {
	fprintf(stdout, "image-format: not %s or %s\n", id87, id89);
	exit(1);
    }
    strncpy(format, buf, 6);
    format[6] = 0;
    fprintf(stdout, "image-format: %s\n", format);

    if (read(fd, buf, 7) != 7) {
	perror("read");
	exit(1);
    }
    RWidth = buf[0] + (buf[1] << 8);
    RHeight = buf[2] + (buf[3] << 8);
    BitPixel = 2 << (buf[4] & 0x07);
    ColorResolution = (((buf[4] & 0x70) >> 3) + 1);
    Background = buf[5];
    AspectRatio = buf[6];
    HasColormap = buf[4] & LOCALCOLORMAP;

#ifdef notdef
    printf("width: %d\n", RWidth);
    printf("height: %d\n", RHeight);
#endif
    printf("image-colors: %d\n", BitPixel);
#ifdef notdef
    printf("color-resolution: %d\n", ColorResolution);
    printf("background: %d\n", Background);
    printf("aspect-ratio: %d\n", AspectRatio);
#endif

    /* Read in global colormap. */
    if (HasColormap) {
	if (read(fd, buf, BitPixel * 3) != BitPixel * 3) {
	    perror("read");
	    exit(1);
	}
    }
    /* Check for image seperator */
    notquit = 1;
    while (notquit) {
	if (read(fd, buf, 1) != 1) {
	    perror("read");
	    exit(1);
	}
	switch (buf[0]) {
	case ';':
	    break;
	case '!':
	    read(fd, &exttype, 1);
	    do {
		read(fd, &count, 1);
		if (count > 0)
		    read(fd, buf, count);
	    } while (count > 0);
	    switch (exttype) {
	    case 0x01:
		/*printf("Plain Text Extension\n"); */
		break;
	    case 0xff:
		/*printf("Application Extension\n"); */
		break;
	    case 0xf9:
		/*printf("Graphic Control Extension\n"); */
		break;
	    case 0xf3:
		/*printf("Comment Extension\n"); */
		buf[count] = '\0';
		printf("Comment: %s\n", buf);
		break;
	    default:
		break;
	    }
	    break;
	case ',':
	    notquit = 0;
	    break;
	default:
	    fprintf(stderr, "Got unexpected char %02x\n", buf[0]);
	    break;
	}
    }

    /* Now read in values from the image descriptor */
    read(fd, buf, 9);

    if (buf[8] & LOCALCOLORMAP) {
	BitPixel = 1 << ((buf[8] & 0x07) + 1);
	if (read(fd, buf, BitPixel * 3) != BitPixel * 3) {
	    perror("read");
	    exit(1);
	}
    }
    LeftOfs = buf[0] + (buf[1] << 8);
    TopOfs = buf[2] + (buf[3] << 8);
    Width = buf[4] + (buf[5] << 8);
    Height = buf[6] + (buf[7] << 8);
    Interlace = buf[8] & INTERLACEMASK;

    printf("image-width: %d\n", Width);
    printf("image-height: %d\n", Height);
    printf("image-type: %sinterlaced\n", (Interlace) ? "" : "non-");

    close(fd);
    exit(0);
}
