#include <malloc.h>
#include <memory.h>

#include "mst.h"
#include "datastruct.h"
#include "prim.h"

typedef struct {
  int no;                                /* node number */
  int parent;                            /* parent node */
  double key;                           /* cost estimation to this node */
  } Node, *NodeP;

#define Parent(x)     (((x)-1)/2)
#define Left(x)       ((x)*2+1)
#define Right(x)      ((x)*2+2)
#define swap(x,y,t)   ((t)=(x), (x)=(y), (y)=(t))
#define EVER          (;;)

static NodeP Q;                          /* cost priority queue */
static int qsize;                        /* cost priority queue size */

void heapify(i)
int i;
{
  Node tmp;
  register l, r, least;

  for EVER {
    l = Left(i);
    r = Right(i);
    least = ((l < qsize) && (Q[l].key < Q[i].key)) ? l : i;
    if ((r < qsize) && (Q[r].key < Q[least].key)) least = r;
    if (least != i) {
      swap(Q[i], Q[least], tmp);
      i = least;
    }
    else return;
  }
}

dec_key(i, key)
int i;
double key;
{
  Node tc;

  Q[i].key = key;
  while (i>0 && Q[Parent(i)].key >= key) {
      swap(Q[i], Q[Parent(i)], tc);
      i = Parent(i);
  }
  return 0;
}

Node extract_min()
{
  Node min;

  min = Q[0];
  Q[0] = Q[--qsize];
  Q[qsize] = min;
  heapify(0);
  return min;
}

void prim()
{
  int i;
  Node u;

  qsize = nodes;
  Q = (NodeP)  malloc(qsize * sizeof(Node));
  for (i=0; i<nodes; i++) {
    Q[i].no = i;
    Q[i].key = Inf;
    Q[i].parent = -1;
  }
  Q[0].key = 0;                        /* root node is 0 */
  
  while (qsize > 1) {
    u = extract_min();
    for (i=0; i<qsize; i++) {
      if (connects[u.no][Q[i].no]) {
        if (Q[i].key > distances[u.no][Q[i].no]) {
          Q[i].parent = u.no;
          dec_key(i, distances[u.no][Q[i].no]);
        }
      }
    }
  }
  Imzero(connects);
  for (i=0; i<nodes; i++) {
    if (Q[i].parent != -1) {
      connects[Q[i].no][Q[i].parent] = connects[Q[i].parent][Q[i].no] = 1;
    }
  }
}
