#include <stdio.h>

#include "mst.h"
#include "prim.h"
#include "datastruct.h"

Fmatrix distances;
Imatrix connects;
int nodes;
int connect_req;

Ivector degree;
 
read_distance ()
{
  int i, j;

  distances = Fmalloc (nodes);
  connects = Imalloc (nodes);
  for (i = 0; i < nodes; i++)
    for (j = 0; j < nodes; j++)
      {
	scanf ("%lf", &distances[i][j]);	/* distance between each pair */
	if (distances[i][j] == 1000000.00)
	  {
	    distances[i][j] = Inf;
	    connects[i][j] = 0;
	  }
	else
	  connects[i][j] = 1;
      }
  return 0;
}

read_raw_distance ()
{
  int i, j;
  float metric, round_trip_time, bandwidth;

  distances = Fmalloc (nodes);
  connects = Imalloc (nodes);
  for (i = 0; i < nodes; i++)
    for (j = 0; j < nodes; j++)
      {
	scanf ("%f", &round_trip_time);
	scanf ("%f", &bandwidth);

	if (round_trip_time < 0.0 && bandwidth < 0.0)
	  metric = Inf;
	else if (round_trip_time < 0.0)
	  round_trip_time = 400.0;
	else if (bandwidth < 0)
	  bandwidth = 512.0;

	if (metric > 0.0 && bandwidth > 0.0)
	  metric =  bandwidth / round_trip_time;

	if (metric < 0.0)
	  metric = Inf;

	distances[i][j] = metric;
	if (metric == Inf)
	  connects[i][j] = 0;
	else
	  connects[i][j] = 1;
      }
  return 0;
}

/* Make an upper triangular matrix by taking the new distance from
 * [a,b] to be ([a,b] + [b,a]) / 2).
 */
 
average_distances ()
{
  int i, j;
  float average;

  for (i = 0; i < nodes; i++)
    for (j = i; j < nodes; j++)
      {
	average = (distances[i][j] + distances[j][i]) / 2.0;
	distances[i][j] = average;
	distances[j][i] = average;
      }
}

display_connection ()
{
  int i, j;
  printf ("%d\n", nodes);
  for (i = 0; i < nodes; i++)
    {
      for (j = 0; j < nodes; j++)
	{
	  printf (" %c", (connects[j][i]) ? '1' : '0');
	}
      puts ("");
    }
  return 0;
}

display_cost ()
{
  int i, j;
  for (i = 0; i < nodes; i++)
    {
      for (j = 0; j < nodes; j++)
	{
	  if (connects[i][j])
	    printf ("%5.1lf", distances[i][j]);
	  else
	    printf ("  Inf");
	}
      puts ("");
    }
  return 0;
}

/*
 * We want to add edges to MST so that we have redundancy.
 * We want to add relatively nice edges.
 */

satisfy_connectivity_requirements ()
{

  int done = 0;
  int i, j;

  /* First, determine the connectivity degree for each node */
  degree = Ivalloc (nodes);

  for (i = 0; i < nodes; i++)
    for (j = 0; j < nodes; j++)
      if (connects[i][j])
	degree[i]++;

#ifdef NEVER
  for (i = 0; i < nodes; i++)
    printf ("%d: %d\n", i, degree[i]);
#endif

  while (!done)
    {
      done = 1;			/* assume the worst */
      for (i = 0; i < nodes; i++)
	{
	  if (degree[i] < connect_req)
	    {
	      float min_cost;
	      int   min_edge = -1;

	      /* find minimum edges cost that is not in use */
	      for (j = 0; j < nodes; j++)
		{

		  if (!connects[i][j] && ((min_cost > distances[i][j]) ||
					  (min_edge == -1)))
		    {
		      min_cost = distances[i][j];
		      min_edge = j;
		    }
		}
	      if (min_edge != -1)
		{
		  connects[i][min_edge] = 1;
		  connects[min_edge][i] = 1;
		  degree[i]++;
		  degree[min_edge]++;
		  done = 0;
		}
	    }
	}
    }
}
main (argc, argv)
     int argc;
     char *argv[];
{
/*  if (--argc) freopen (argv[argc], "r", stdin); */
  scanf ("%d", &connect_req);	/* connectivity requirement */
  scanf ("%d", &nodes);		/* # of nodes */
  read_raw_distance ();
  average_distances ();
/*  display_cost();  */
  prim ();
  satisfy_connectivity_requirements ();
  display_connection ();
#if defined(DIAMETER)
  diameter ();
#endif
  exit (0);
}
