#include <stdio.h>
#include <stdlib.h>
#if defined (HAVE_MALLOC_H)
#include <malloc.h>
#endif
#include <xmalloc.h>

void *
xmalloc (int n)
{
  if (n == 0)
    return (NULL);
  else
    return (xrealloc (NULL, n));
}

void *
xrealloc (void *ptr, int n)
{
  void *result;

  if (ptr)
    result = realloc (ptr, n);
  else
    result = malloc (n);

  if (result == NULL)
    {
      fprintf (stderr, "Out of Virtual Memory\n");
      abort ();
    }
  return (result);
}

void
xfree (void *ptr)
{
  if (ptr != NULL)
    free (ptr);
}

