#include <stdio.h>
#include <sys/time.h>
#include <timeval.h>

/* compute the total millisecond difference between two values */
/* doesn't handle negative time.
 * Assumes microsecond resolution
 */
struct timeval
timeval_subtract (struct timeval t1, struct timeval t2)
{
  struct timeval result;

  if (t1.tv_usec >= t2.tv_usec)
    result.tv_usec = t1.tv_usec - t2.tv_usec;
  else    /* have to do arithmetic borrow */
    {
      long tmp;
      tmp = t1.tv_usec - t2.tv_usec;
      result.tv_usec = tmp + 1000000;
      t1.tv_sec--;
    }

  if (t1.tv_sec >= t2.tv_sec)
    result.tv_sec = t1.tv_sec - t2.tv_sec;
  else
    {
      result.tv_sec = 0;
      result.tv_usec = 0;
    }

  return (result);
}

struct timeval
timeval_add (struct timeval a, struct timeval b)
{
  struct timeval result;

  result.tv_sec = a.tv_sec + b.tv_sec;

  if (a.tv_usec + b.tv_usec > 1000000)
    result.tv_sec += ((a.tv_usec + b.tv_usec) / 1000000);

  result.tv_usec = (a.tv_usec + b.tv_usec) % 1000000;
  return (result);
}

/* Compare two timeval structures
 * Cases:
 *   (x < y) -1
 *   (x == y)  0
 *   (x > y)  1
 */
int
timeval_compare (struct timeval *x, struct timeval *y)
{
  if (x->tv_sec < y->tv_sec)
    return (-1);

  if (x->tv_sec > y->tv_sec)
    return (1);

  if (x->tv_usec < y->tv_usec)
    return (-1);
  if (x->tv_usec > y->tv_usec)
    return (1);

  return (0);
}

struct timeval
timeval_current ()
{
  struct timeval current_time;
  struct timezone zone = {0, 0};
  gettimeofday (&current_time, &zone);
  return (current_time);
}

struct timeval
timeval_from_seconds (int secs)
{
  struct timeval result;

  result.tv_sec  = secs;
  result.tv_usec = 0;
  return (result);
}



