/* $Id: message.h,v 1.1 1995/04/22 21:53:19 dante Exp $ */
#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#define MESSAGE_SIZE 36

/* Message types */
typedef enum
{
  TYPE_PING, TYPE_PING_REPLY, TYPE_BANDWIDTH, TYPE_DATA, TYPE_TOPOLOGY,
  TYPE_ESTIMATES, TYPE_JOIN, TYPE_FEDEX, TYPE_UNKNOWN, TYPE_ACK
} MessageType;

typedef struct
{
  SiteID site;
  struct timeval time;
} MessageID;


typedef struct
{
  MessageType type;
  MessageID id;
  SiteID sender;
  union
    {
      struct timeval time_sent;
      int length;
    } data;
} Message;


#endif /* _MESSAGE_H_ */
