/* $Id: main.c,v 1.2 1995/04/28 06:38:03 dante Exp dante $ */
#include <stdio.h>
#include <stdlib.h>
#include <xmalloc.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <sys/socket.h>
#if defined (HAVE_SYSLOG_H)
#  include <syslog.h>
#endif /* !SYS_SYSLOG */
#include <netdb.h>

#include <floodd.h> 
#include <client.h>
#include <message.h>
#include <group.h>
#include <export.h>

int data_socket;
int ping_socket;
int client_socket;

List *site_list;
SiteInfo **sites;


List *group_list;
Group **groups;

SiteInfo *whoami = NULL;

Queue *export_queue = NULL;	/* A queue to hold the datablock that are to
				 * be export to the local application
				 */
int export_fd = -1;		/* The current fd descriptor for the exporter
				 * (if one exists).
				 */
int daemon = 1;			/* Run as a daemonprocess */
int print_pid = 0;		/* print out the process id */
int debug = 0;
extern char *version;

/*
 * User settable variables  
 */
char *export_command = NULL;	/* command we use to export data to the local
				 * appication 
				 */

char *access_file = NULL;	/* A file with only access (allow, deny) info */

char *auxillary_info = NULL;	/* A url for something */

int log_purge_period = 60 * 60;	/* how long to keep logs around (in seconds)*/
int site_purge_period = 60 * 60; /* How often to purge sites not heard from */
int bandwidth_size = 32768;	/* size of the bandwidth estimate message  */
char *maintainer = NULL;	/* The email contact for the maintainer */
char *password = NULL;		/* password for maintaince access */

#ifdef SETPROCTITLE
char            **Argv = NULL;          /* pointer to argument vector */
char            *LastArgv = NULL;       /* end of argv */
# endif /* SETPROCTITLE */


process_config_file (char *filename)
{
  struct stat statbuf;
  char *buffer;
  int file;

  /*
   * open the configuration file and stuff it into a buffer
   */
  
  if (stat (filename, &statbuf) < 0)
    {
      fprintf (stderr, "Could not open configuration file `%s',\n", filename);
      perror ("flood");
      exit (1);
    }
  
  buffer = xmalloc (statbuf.st_size + 1);

  file = open (filename, O_RDONLY);
  if (file == -1)
    {
      if (debug)
	{
	  fprintf (stderr, 
		   "Could not open configuration file `%s'\n", filename);
	  perror ("floodd");
	}
      exit (1);
    }
  read (file, buffer, statbuf.st_size);
  close (file);

  buffer[statbuf.st_size] = '\0';
  parse_config_string (buffer, 2); /* output errors to stderr */

  xfree (buffer);
}

void
initialize (char *my_name)
{
  struct sockaddr_in address;
  struct linger linger;
  struct stat statbuf;
  char *filename = NULL;
  int i;
  int on = 1;

  /* Block SIGPIPE Signals */
  signal (SIGPIPE, SIG_IGN);

  if (getenv ("FLOODD_ACCESS_FILE"))
    access_file = strdup (getenv ("FLOODD_ACCESS_FILE"));
  else
    access_file = strdup ("floodd-access");

  /* initialize some global data structures */
  group_list = list_new (NULL, NULL);
  site_list = list_new (NULL, NULL);

  /* Open Site file - check for an environment variable first though */
  filename = (char *)getenv ("FLOODD_CONFIG");

  if (filename != NULL)
    filename = strdup (filename);

  /* Check for a file floodd-<name> */
  if (filename == NULL)
    {
      if (my_name != NULL)
	{
	  filename = xmalloc (strlen ("floodd-") + strlen(my_name) + 1);
	  strcpy (filename, "floodd-");
	  strcat (filename, my_name);
	  if (stat (filename, &statbuf) < 0)
	    {
	      /* Otherwise just use the default */
	      xfree (filename);
	      filename = NULL;
	    }
	}

      if (filename == NULL)
	filename = strdup (FLOODD_CONFIG);
    }
  
  process_config_file (filename);

  if (groups == NULL)
    {
      if (debug)
	fprintf (stderr, "No groups read.\n");

      exit (1);
    }

  /* Find out who I am */
  
  whoami = find_myself (groups[0], my_name);

  if (whoami == NULL)
    {
      if (debug)
	{
	  if (my_name != NULL)
	    fprintf (stderr, "Cannot find my site name `%s' in config file\n", 
		     my_name);
	  else
	    fprintf (stderr, "Cannot determine site id.\n");
	}
      exit (1);
    }

  /* Open sockets on which to listen */

  /* Open up a socket on which to listen for ping requests */

  ping_socket = socket (AF_INET, SOCK_DGRAM, 0);
  if (ping_socket < 0)
    {
      perror ("socket()");
      exit (1);
    }

  setsockopt (ping_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));

  address.sin_family = AF_INET;
  address.sin_addr.s_addr = INADDR_ANY;
  address.sin_port = htons(whoami->data_port);

  if (bind (ping_socket, (struct sockaddr *)&address, sizeof (address)))
    {
      perror ("bind()");
      exit (1);
    }

  /* Open up a socket on which to listen for data from other floodds */
  data_socket = socket (AF_INET, SOCK_STREAM, 0);
  if (data_socket < 0)
    {
      perror ("socket()");
      exit (1);
    }

  setsockopt (data_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof (on));

  /* Set up the address of the router and destination*/

  if (bind (data_socket, (struct sockaddr *) &address, whoami->address_length))
    {
      perror ("bind()");
      exit (1);
    }

  if (listen (data_socket, 5) < 0)
    {
      perror ("listen()");
      exit (1);
    }

  /* Set up a socket on which to listen for client requests */
  client_socket = socket (AF_INET, SOCK_STREAM, 0);
  if (client_socket < 0)
    {
      perror ("socket()");
      exit (1);
    }

  setsockopt (client_socket, SOL_SOCKET, SO_REUSEADDR, (char *)&on, 1);

  linger.l_onoff = 0;
  linger.l_linger = 0;

  setsockopt (client_socket, SOL_SOCKET, SO_LINGER, (char *) &linger, sizeof (linger));

  address.sin_port = htons(whoami->client_port);

  if (bind (client_socket, (struct sockaddr *) &address, sizeof (address)))
    {
      perror ("bind()");
      exit (1);
    }

  if (listen (client_socket, 5) < 0)
    {
      perror ("listen()");
      exit (1);
    }

  for (i = 0; groups[i] != NULL; i++)
    group_initialize (groups[i]);

  /* Set up the export queue */
  export_queue = queue_new ();

  xfree (filename);
#ifdef STATISTICS
  initialize_counters ();
#endif /* STATISTICS */
}

/* Disconnect the process from the controlling terminal */
int
disconnect ()
{
  int pid;
  int fd;

#ifdef SIGTTOU 
  signal (SIGTTOU, SIG_IGN);
#endif

#ifdef SIGTTIN
  signal (SIGTTIN, SIG_IGN);
#endif

#ifdef SIGTSTP
  signal (SIGTSTP, SIG_IGN);
#endif

  pid = fork ();
  if (pid)
    {
      return (pid);
    }

  if (setpgrp  (0, getpid ()) == -1)
    {
      syslog (LOG_ERR, "Can't change process group: %m");
      exit (1);
    }

  /*
   * Redirect the standard input standard output and standard error.
   */
  fd = open ("/dev/null", O_RDWR);
  dup2 (fd, 0);
  dup2 (fd, 1);
  dup2 (fd, 2);

  signal (SIGINT, SIG_IGN);
  signal (SIGQUIT, SIG_IGN);

  return (0);
}

dump_core ()
{
  chdir ("/tmp");
  abort ();
}

extern char *optarg;
extern int optind, opterr;

main (int argc, char **argv, char **envp)
{
  char *my_name;
  int errors;
  int pid;
  char opt;

  while ((opt = getopt (argc, argv, "pd")) != EOF)
    switch (opt)
      {
      case 'p': print_pid++;	/* print out the process id */
	break;
      case 'd':		/* Debug */
	if (optarg != NULL)
	  debug = atoi (optarg); 
	else 
	  debug = 0;

	if (debug == 0)
	  debug = 10;
	daemon = 0;
	break;
      default:  errors++;	break;
      }
  
  if (optind < argc)
    my_name = strdup (argv[optind]);
  else
    my_name = NULL;

  if (debug && !daemon)
    printf ("Floodd version %s\n", version);

  /* Setup of syslog */
  /* This ifdef is probably not a good test, but I don't know that much about
   * syslog implementations.  Does anyone else?
   */
#if defined (LOG_CONS)
  openlog ("floodd", LOG_PID | LOG_CONS | LOG_NOWAIT, LOG_USER);
#else
  openlog ("floodd", LOG_PID);
#endif

  if (daemon)
    pid = disconnect ();
  else
    pid = getpid ();

  if (print_pid)
    printf ("%d\n", pid);

  /* exit if we are the parent and we are in daemon mode */
  if (pid && daemon)
    exit (0);

  initialize (my_name);

#ifdef SETPROCTITLE
  /*
   **  Save start and extent of argv for setproctitle.
   */
  Argv = argv;
  LastArgv = argv[argc - 1] + strlen(argv[argc - 1]);

  setproctitle ("%d", whoami->id.port.port);

#endif /* SETPROCTITLE */

  /* Ok, we are gonna be daemon process, so we need to change directory to
   * to the root so we can allow partitions and such to be unmounted.
   */
  chdir ("/");

  io_initialize ();

  /* setup up a signal handler for a core dump */
  signal (SIGBUS, (void *) dump_core);
  signal (SIGSEGV, (void *) dump_core);
  signal (SIGQUIT, (void *) dump_core);
  signal (SIGILL, (void *) dump_core);
#if defined(SIGSYS)
  signal (SIGSYS, (void *) dump_core);
#endif
  /* Start the join protocol */

  join_groups ();

  event_thread ();
}
