#Date:         Fri, 27 May 1994 18:08:24 +0800
#From:         Mathias <mathias@swi.com.sg>
#Organization: SW International Systems Pte Ltd
#To:           sanders@earth.com
#Subject:      plexus 3: access-local.pl
#Reply-To:     Mathias.Koerber@swi.com.sg
#
#Hi Tony,
#
#I have hacked an access filter for perl based on a combi of your
#two supplied ones.
#
#This one understand a 'local' directive in the access-filter.conf
#to restrict access to local users (same network). Similar to
#fail.
#
#I had some problems withe the unpack and binary AND,
#so I did a absolute check first.
#
#I guess that unpacking a socket addres (as done in
#access-sample) does not yield a value usable with
#& 0xffffff00. I alsways get 0. I'll investigate
#further.
#
#here, first, is my current access filter.
#
#Mathias
#-- 
#Mathias Koerber	                    | Tel: +65 / 7780066 ext 29
#SW International Systems Pte Ltd    | Fax: +65 / 7779401
#14 Science Park Drive #04-01        |
#The Maxwell, Singapore Science Park | email: Mathias.Koerber@swi.com.sg
#Singapore 0511                      |        mathias@solomon.technet.sg
#-------------------------------------------------------------------------------
#
#
# access-local.pl -- Disallow access to certain paths
#			for users not local, also
#			disallow total
#
# 
# based on access-filter.pl and access-sample.pl 
# by Tony Sanders <sanders@earth.com>, Oct 1993
#
# Read a configuration file and disallow certain paths
# Requires configuration.

sub access {
    local($fromfd, $peeraddr, $action, $path, $version) = @_;
    local($mynet) = pack("C4", 202, 0, 71, 0);          # our Class C network
    local($mymask) = 0xffffff00;                        # mask for Class C
    local($_, $pat) = $path;

    local($mya,$myb,$myc,$myd)=unpack("C4",$mynet);
    local($peer)=(unpack($main'sockaddr,$peeraddr))[2];
    local($pra,$prb,$prc,$prd)=unpack("C4",$peer);
    foreach $pat (@access_filter'lines) {
	#&main'debug("testing $pat");
	local($type) = chop($pat);
        if ($type eq 'p') {
            # pass
            /$pat/ && last;
	} elsif ($type eq 'l') {
	    # fail (only if not on local net)
	    last if (($mya == $pra) && ($myb == $prb) && ($myc == $prc));
	    /$pat/ && &main'error('forbidden', "$action $path invalid");
	} else {
	    # fail
	    /$pat/ && &main'error('forbidden', "$action $path invalid");
	}
    }
}

package access_filter;

&access_filter'config($main'plexus{'access-filter-config'});

sub config {
    &main'debug("config $_[0]");
    local($config) = shift || die "access-filter: no config file\n";
    local($pat);
    @lines = ();
    &main'open("access_filter'CONFIG", $config) || die "$config: $!";
    while (<CONFIG>) {
        if (/^\s*pass\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'p'); next; }
        if (/^\s*fail\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'f'); next; }
        if (/^\s*local\s*(.*)/) { $pat = &main'globpat($1); push(@lines, $pat . 'l'); next; }

    }
    close(CONFIG);
}

1;
