#Date:         Sat, 14 May 1994 12:21:13 +0800
#From:         mwette@grover.jpl.nasa.gov (Matt Wette)
#To:           fenner@herman.cmf.nrl.navy.mil
#Cc:           Matthew.R.Wette@jpl.nasa.gov, sanders@earth.com
#Subject:      plexus: access control by IP addr
#
#Hi William,
#
#I found your name in the plexus stuff.  I've also been working on access
#control by IP address.  In addition, I plan to start working on root
#page by IP address.   Here's a sample of what I have.  First is a sample
#"access-byaddr.conf" file.  The first column is IP address, the rest are
#a list of directories and/or files which pass.  I would like to add failures
#(e.g., /pub,!/pub/xyz would pass /pub but fail /pub/xyz).  After that is
#my access-byaddr.pl file, which is used similar to access-filter.pl.
#Could you let me see what you have.  Maybe I can grab yours or we can work
#together on this.
#
#Matt Wette
#matthew.r.wette@jpl.nasa.gov
#
#	# access-byaddr.conf
#	*.*.*.*		/pub
#	#
#	128.149.*.*	/pub,/jpl
#	137.79.77.*	/pub,/jpl,/sec343
#
#
# access-byaddr.pl -- Disallow access to certain paths
#
# access-byaddr.pl,v 1.1 1994/06/23 05:42:39 sanders Exp
#
# history -
#	06Jan94	M.Wette: derived from access-filter.pl
#

sub access {
  local($fromfd, $peeraddr, $action, $path, $version) = @_;
  local($peer, $i, $net, $dir, $ok);
  local(@dirs) = ();
  $inetaddr = (unpack($main'sockaddr, $peeraddr))[2];
  $peer = join('.', unpack('C4', $inetaddr));
  #&logger'message("peer=$peer\n");
  if ($path eq "index.html") { return 0; }
  for ($i = 0; $i < $access_byaddr'nent; $i++) {
    $net = $access_byaddr'nets[$i];
    $dir = $access_byaddr'dirs[$i];
    if ($peer =~ /$net/) {
      @dirs = split(/,/, $dir);
    }
  }
  if ($#dirs < 0) {
    &main'error('forbidden', "$action $path denied");
    return 1;
  }
  $ok = 0;
  foreach $dir (@dirs) {
    if ($path =~ m@^$dir@) { $ok = 1; }
  }
  if (! $ok) {
    &main'error('forbidden', "$action $path denied");
    return 1;
  }
}

package access_byaddr;

&access_byaddr'config($main'plexus{'access-filter-config'});

sub config {
  &main'debug("config $_[0]");
  local($config) = shift || die "access-byaddr: no config file\n";
  local($net,$dir);
  @nets = ();
  @dirs = ();
  $nent = 0;
  &main'open("access_byaddr'CONFIG", $config) || die "$config: $!";
  while (<CONFIG>) {
    if (/^\s*#/) { next; }  
    if (/^\s*$/) { next; }
    chop;
    s/#.*//;
    if (/^\s*(\S+)\s+(\S+)/) {
      $net = $1; $dir = $2;
      $net =~ s@\*@[0-9]+@; $net =~ s@\.@\\.@g;
      push(@nets, $net);
      $dir =~ s@^/@@;
      $dir =~ s@([^/])$@$1/@;
      $dir =~ s@,/@,@g;
      $dir =~ s@([^/]),@$1/,@;
      push(@dirs, $dir);
      $nent++;
      next;
    }
    print STDERR "bad line\n";
  }
  close(CONFIG);
}

1;

