#include "defs.h"

/* must recognize the beginnings of a url with or without a backslash
 */
int is_url(char *filename)
{
    char *cp=filename;
    char *cp2;

    /* kill beginning spaces */
    while(isspace(*cp)) cp++;

    if(!strncmp(cp,"news:",5)) {
	return(NEWS_URL_TYPE);

    } else if(!strncmp(cp,"news\\:",5)) {
	return(NEWS_URL_TYPE);

	/* if it doesn't contain "://" then it can't be a url 
	 * except for news:
	 */
    } else if(!strstr(cp+4,"://")) {  
	return(0);

    } else if(!strncmp(cp,"http",4)) {
	return(HTTP_URL_TYPE);

    } else if(!strncmp(cp,"file",4)) {
	return(FILE_URL_TYPE);

    } else if(!strncmp(cp,"wais",4)) {
	return(WAIS_URL_TYPE);

    } else if(!strncmp(cp,"prospero",8)) {
	return(PROSPERO_URL_TYPE);

    } else if(!strncmp(cp,"afs",3)) {
	return(AFS_URL_TYPE);

    } else if(!strncmp(cp,"telnet",6)) {
	return(TELNET_URL_TYPE);

    } else if(!strncmp(cp,"tn3270",6)) {
	return(TN3270_URL_TYPE);

    } else if(!strncmp(cp,"rlogin",6)) {
	return(TN3270_URL_TYPE);

    } else if(!strncmp(cp,"gopher",6)) {
	if((cp2 = strchr(cp+11,'/')) != NULL &&
		toupper(*(cp2+1)) == 'H')
	/* if this is a gopher html type */
	    return(HTML_GOPHER_URL_TYPE);
	else
	    return(GOPHER_URL_TYPE);

    } else {
	return(0);
    }
}
