/*
 * Lynx.c - Hypertext navagation system
 *
 * SYNOPSIS:
 *	lynx [path]
 *
 * EXPLANATION
 *      This is a general hypertext browser, with some fancy features.
 *      This program uses a superset of the hytelnet file format which
 *      is a derivative of HYPERRES, so it should be 
 *      possible to plug-and-play other databases as well.
 *     
 *      The database consists of many more-or-less plain text files,
 *      on any file system.  Any text in angle brackets (eg <HELP>)
 *      is a link, it is also possible to change the link delimiter
 *      (eg %HELP%).  Selecting it moves you to the named file. 
 *	Files can reside on remote systems and can be accessed through
 * 	internet gopher servers.  A gopher client is built into lynx. 
 *
 *      The program notices telnet commands embedded in the text files,
 *      and will execute them for the user, if desired.
 *
 * NOTES
 *	Big thanks to 
 *      Earl Fogel, Computing Services, University of Saskatchewan
 *	fogel@sask.usask.ca from who's code this whole thing started from
 *
 *	Thanks to Michael A. Crowley (mcrowley@mtholyoke.edu) for some
 *      of the interrupt handling code.
 *
 *	Thanks to Kathryn Huxtable (huxtable@kuhub.cc.ukans.edu) for the
 *	VMS termio routines, and various other VMS oddities.
 *
 * BUGS
 *    - Should do resize if term is resizable (eg. xterm)
 *    - Should distinguish between the escape key and escape sequences
 *      (ie. cursor keys).
 *
 * AUTHORS
 *	Lou Montulli, University of Kansas, Computing Services
 *	Montulli@KUHUB.cc.ukans.edu
 *
 *	Michael Grobe, University of Kansas, Computing Services
 *	Grobe@KUHUB.cc.ukans.edu
 *
 *	Charles Rezac, University of Kansas, Computing Services
 *	Rezac@KUHUB.cc.ukans.edu
 *
 * CHANGE LOG
 *
 * NOTICE
 *	Permissions to copy, use and redistribute this program are hereby
 *	granted provided the Copyright notice and this comment remain
 *	intact.
 *
 *		    (c) Copyright 1992 ?Lou Montulli?  Who knows anymore??
 */

#define MAXINT 2147483647

#ifndef BOOLEAN_DEFINED
#define BOOLEAN char /* boolean variabels use char because they are 8 bits */
#define BOOLEAN_DEFINED
#endif BOOLEAN_DEFINED

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>

#include "userdefs.h"
#ifndef GLOBAL_DEFS
#include "global_defs.h"
#endif

#ifdef ULTRIX
#include <cursesX.h>
#else
#include <curses.h>
#endif ULTRIX

#ifdef MSDOS
#include "pccurses.h"
#include "userdefs.h"
#define TRUE 1
#define FALSE 0
#endif MSDOS

/* define curses functions */
#ifdef FANCY_CURSES

#ifdef VMS
#define start_bold()      setattr(_BOLD)
#define start_underline() setattr(_UNDERLINE)
#define start_reverse()   setattr(_REVERSE)
#define stop_bold()       clrattr(_BOLD)
#define stop_underline()  clrattr(_UNDERLINE)
#define stop_reverse()    clrattr(_REVERSE)
#else
#define start_bold()      attron(A_BOLD)
#define start_underline() attron(A_UNDERLINE)
#define start_reverse()   attron(A_REVERSE)
#define stop_bold()       attroff(A_BOLD)
#define stop_underline()  attroff(A_UNDERLINE)
#define stop_reverse()    attroff(A_REVERSE)
#endif /* VMS */

#else /* not FANCY_CURSES */
#define start_bold()      1  /* nothing */
#define start_underline() 1  /* nothing */
#define start_reverse()   standout()
#define stop_bold()       1  /* nothing */
#define stop_underline()  1  /* nothing */
#define stop_reverse()    standend()
#endif /* FANCY_CURSES */

#define ON	1
#define OFF	0
#define STREQ(a,b) (strcmp(a,b) == 0)
#define STRNEQ(a,b,c) (strncmp(a,b,c) == 0)
#define printable(c) (((c)>31 && (c)<=127) || (c)==9 || (c)==10)
#define HLINE	-60	/* horizontal line segment */
#define VLINE	-77	/* vertical line segment */
#define VLINE2	-70	/* vertical line segment */
#define UL	-38	/* upper left corner */
#define UR	-65	/* upper right corner */
#define LL	-64	/* lower left corner */
#define LR	-39	/* lower right corner */
#define UL2	-42	/* upper left corner */
#define UR2	-73	/* upper right corner */
#define LL2	-45	/* lower left corner */
#define LR2	-67	/* lower right corner */
#define BULLET	4	/* list item marker */
#define BLOT1	-78
#define BLOT2	-79
#define BLOT3	-80
#define BS	8
#define NOT_FOUND 0
#define LOCAL 1
#define GOPHER 2
#define NULLFILE 3

#define UPARROW	201
#define DNARROW	202
#define RTARROW	203
#define LTARROW	204
#define PGDOWN  205
#define PGUP    206
#define HOME    207
#define END	208
#define F1	209

#define FORM_UP   1
#define FORM_DOWN 2

/* #define different lynx modes */
#define NORMAL_LYNX_MODE 1
#define FORMS_LYNX_MODE  2
#define WWW_LYNX_MODE    3

/* universal document id types */
#define HTTP_URL_TYPE     1
#define FILE_URL_TYPE     2
#define WAIS_URL_TYPE     3
#define PROSPERO_URL_TYPE 4
#define NEWS_URL_TYPE     5
#define TELNET_URL_TYPE   6
#define TN3270_URL_TYPE   7
#define GOPHER_URL_TYPE   8
#define HTML_GOPHER_URL_TYPE 9
#define AFS_URL_TYPE      10


/* form value types */
#define BOOLEAN_TYPE     1
#define INT_TYPE         2
#define DATE_TYPE        3
#define DATE_MONTH_TYPE  12
#define DATE_MDAY_TYPE   13
#define DATE_YEAR_TYPE   14
#define TIME_TYPE        4
#define TIME_HOUR_TYPE   15
#define TIME_MIN_TYPE    16
#define TIME_SECOND_TYPE 17
#define STRING_TYPE      5
#define MONTH_TYPE       6
#define MDAY_TYPE        7
#define YEAR_TYPE        8
#define HOUR_TYPE        9
#define MIN_TYPE         10
#define SECOND_TYPE      11
#define PASSWORD_TYPE    18


/* values for options.c */
#define L_EDITOR  2
#define L_DISPLAY 4
#define L_HOME    6
#define L_GOPHER  8
#define L_SEARCH  10
#define L_EXEC    12
#define L_VIKEYS  14

/* values for links.tcmd */
#define TELNET 1
#define TN3270 2
#define REXEC_T  3
#define RLOGIN 4

struct _printer_type {
    char name[256];
    char command[256];
    int always_enabled;
};
typedef struct _printer_type printer_type;
extern printer_type printer[];

#include "structs.h"

extern int more;


#ifdef VMS
#   define strncasecmp strncmp   /* vms doesn't have strncasecmp */
#define REXEC
#define FANCY_CURSES
#endif


/* type declarations for all functions */

extern char *altstrstr(char *chptr, char *tarptr);
extern BOOLEAN checkfordefines(FILE *fp);
extern void cleanup_files (void);
extern void cleanup_sig (int sig);
extern BOOLEAN defineswitch(char *buffer);
extern BOOLEAN display_a_line(char *buffer, int *cur, int *lineno,
		    	   char *target, BOOLEAN target_present,
		    	   char *gopher_info, char *cur_file, char *base1);
extern void edit_current_file(char *newfile, int cur, int lineno);
extern BOOLEAN exec_a_command(int cur, char *newfile, char *target);
extern int findtarget(FILE *fp, char target[MAXTARGET], BOOLEAN *target_present);
extern void gettargetname(char *buf, int cur);
extern void highlight(int flag, int cur);
extern void historytarget(char *lname, char *gopher_info, char *target,
			  int *cur, int *page);
extern BOOLEAN inlocaldomain(void);
extern char *interaddr(char *cp, char *buf);
extern BOOLEAN ismoretext(char *cp5);
extern char *linkless_search(char *tmptr, char *target);
extern int main(int argc, char *argv[]);
extern void mainloop(char *startdir, char *startfile);
extern int mygetch(void);
extern char *mystrstr(char *buffer, char *target);
extern char *mystrncpy(char *dst, char *src, int n);
extern char *nextword(char *cp);
extern char *parselinks(char *cp, char *base1, int col,
			int lineno, char *cur_file, BOOLEAN *show_next_char,
			struct attribtype *attrib, char *gopher_info);
extern void refinehightext(char *text, int len);
extern void reply_by_mail(char *newfile);
extern void mailmsg (int cur,char *owner_address,char *filename,char *linkname);
extern BOOLEAN setup(char *terminal);
extern void showhistory(char newfile[]);
extern int showpage(FILE **fp, int *cur_line, int oldline, int savline,
		    BOOLEAN target_present,
		    char *target, char *cur_file,
		    char *base1, int *cur, char *gopher_info, char *owner);
extern int showinfo(int cur, char *newfile, char *prevlinkname, 
	     		char *target, int lines_in_file);
extern void size_change(void);
extern void start_curses(void);
extern void stop_curses(void);
extern void statusline(char *text);
extern BOOLEAN textsearch(FILE *fp, int *newpage, int cur, char *target, 
		      BOOLEAN *target_present, char *prev_target);
extern char *uncapitalize(char *buf);
/* gopher routine */
extern char *do_gopher(char *newfile, char *hightext, char *search_string,
							FILE *current_fp);


