#include "defs.h"

BOOLEAN defineswitch(char *buffer); 
/*
 * defineswitch checks a line to see if it has any lynx specific commands.
 * if the line contains a command, it parses the command and sets the 
 * appropriate variable.  defineswitch returns TRUE if there are any
 * commands on the line and false otherwise.  In addition, to support
 * defines added in the future, unrecognized lines begining with '%%'
 * are considered to be unknown defines, and will return TRUE.
 */
BOOLEAN defineswitch(char *buffer)
{
    char *cp, *cp2, *cp3;

	if(mystrstr(buffer,"end")!=NULL && 
	   mystrstr(buffer,"link")!=NULL &&
	   (cp=mystrstr(buffer,"delimiter"))!=NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 9;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */
	
 	   delimiter.end_link = *cp;

	} else if(mystrstr(buffer,"link")!=NULL && 
	  (cp=mystrstr(buffer,"delimiter"))!=NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 9;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */
	
 	   delimiter.link = *cp;

	} else if((mystrstr(buffer,"owner") != NULL) &&
	    ((cp = mystrstr(buffer,"address")) != NULL)) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 7;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	   /* kill linefeeds */
	   if((cp2 = strchr(cp,'\n')) != NULL)
		*cp2 = '\0';

	   /* mystrncpy(owner_address, cp,119); */

	   printf("<LINK rev=made href=\"mailto:%s\">\n",cp);

	} else if((mystrstr(buffer,"owner") != NULL) &&
	    ((cp = mystrstr(buffer,"info")) != NULL)) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 4;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	   /* kill linefeeds */
	   if((cp2 = strchr(cp,'\n')) != NULL)
		*cp2 = '\0';

	   /* mystrncpy(owner_info, cp,119); */

	   printf("<!-- OWNER_INFO=\"%s\" -->\n",cp);

	} else if((cp = mystrstr(buffer,"owner")) != NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 5;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	   /* kill linefeeds */
	   if((cp2 = strchr(cp,'\n')) != NULL)
		*cp2 = '\0';

	   /* mystrncpy(owner, cp,119); */

	   printf("<!-- OWNER_NAME=\"%s\" -->\n",cp);

	} else if((cp = mystrstr(buffer,"index")) != NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 5;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	/* copy the filename and kill the return at the end */
	   mystrncpy(indexfile, cp,100);
	   if((cp2 = strchr(indexfile,'\n')) != NULL)
		*cp2 = '\0';  

	} else if(mystrstr(buffer,"end")!=NULL && 
		  mystrstr(buffer,"target")!=NULL &&
		  (cp=mystrstr(buffer,"delimiter"))!=NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 9;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */
	
 	   delimiter.end_target[0] = *cp;
	   if(isgraph(*(cp+1)))
	      delimiter.end_target[1] = *(cp+1);
	   else
	      delimiter.end_target[1] = '\0';


	} else if(mystrstr(buffer,"target")!=NULL &&
		  (cp=mystrstr(buffer,"delimiter"))!=NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 9;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */
	
	   delimiter.target[0] = *(cp);
	   if(isgraph(*(cp+1)))
	      delimiter.target[1] = *(cp+1);
	   else
	      delimiter.target[1] = '\0';


	 } else if(mystrstr(buffer,"token")!=NULL &&
		  (cp=mystrstr(buffer,"delimiter"))!=NULL) {

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 9;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */
	
 	   delimiter.token = *cp;


  	} else if((cp = mystrstr(buffer,"path")) != NULL) { 

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 5;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	   for(cp3=cp; *cp3 != '\n' && *cp3 != '\0' && *cp3 != ' '; cp3++) 
		; /* null body */ 

	   *cp3 = '\0'; /* null terminate string */
	   
	   strcpy(base1,cp); /* */
	
  	} else if((cp = mystrstr(buffer,"title")) != NULL) { 
              /* accept title, but don't do anything with it now */
	} else if((cp = mystrstr(buffer,"lynx_form_server")) != NULL) {
	      /* turn on lynx forms mode */

	   if((cp2 = strrchr(cp,'=')) != NULL)
		cp = cp2+1;
	   else
		cp += 16;

	   while(isspace(*cp)) cp++;  /* get rid of spaces */

	   strcpy(form_server, cp);

	} else { 
		cp = buffer;
		while(isspace(*cp)) cp++; /* get rid of any spaces */
		if(*cp!='%' || *(cp+1)!='%') 
		    return(FALSE);
	 }

	return(TRUE);  /* if there was a define */
} /* big end */
	
