;;!emacs
;;
;; FILE:         rsw-rules.el
;; SUMMARY:      Personal mail handling rules for mhg.
;; USAGE:        GNU Emacs Lisp Library
;;
;; AUTHOR:       Bob Weiner
;; ORG:          Brown U.
;; E-MAIL:       rsw@cs.brown.edu
;;
;; ORIG-DATE:     7-Jan-92 at 03:49:27
;; LAST-MOD:      1-Feb-92 at 02:40:18 by Bob Weiner
;;
;; Copyright (C) 1992 Bob Weiner
;;
;; This file is not part of GNU Emacs.
;;
;; DESCRIPTION:  
;; DESCRIP-END.

(fset 'rsw-file-mail 'mhg-user-refile-rules)
(defun mhg-user-refile-rules ()
  "Computes where to file current mail message based on personal rules."
  (interactive)
  (setq mhg-filed-to nil)
  (let (from bcc cc dcc date in-reply-to reply-to subject summary to field-txt)
    (save-excursion
      (save-restriction
	(goto-char (point-min))
	(if (search-forward "\n\n" nil t)
	    (narrow-to-region (point-min) (point)))
	(mapcar '(lambda (field)
		   (setq field-txt (mail-fetch-field field))
		   (set (intern (downcase field))
			(and field-txt
			     ;; Remove leading and trailing space.
			     (hypb:replace-match-string
			      "\\`[ \t\n\^M]+\\|[ \t\n\^M]+\\'"
			      field-txt ""))))
		'("From" "Subject" "To" "CC" "BCC"))
	))

    (catch 'finish
    (let ((case-fold-search t)
	  (role-regexp
	   (concat (regexp-quote (user-real-login-name))
		   "\\.\\([^@% \t\n\^M]+\\)\\([@%][^@% \t\n\^M]*"
		   (regexp-quote (substring hyperb:host-domain 1))
		   "[^ \t\n\^M]*\\)?\\([ \t\^M]\\|$\\)"))
	  )

    ;; If addressed to an existing role box, just file there and exit.
    (let (hdr folder dir)
      (if (or (and (mhg-hdr-regexp to role-regexp) (setq hdr to))
	      (and (mhg-hdr-regexp cc role-regexp) (setq hdr cc))
	      (and (mhg-hdr-regexp bcc role-regexp) (setq hdr bcc)))
	  (progn
	    (setq folder (hypb:replace-match-string
			  "\\."
			  (substring hdr (match-beginning 1) (match-end 1))
			  "/")
		  dir (concat (or mhg-root-dir mh-user-path) folder))
	    (if (file-exists-p dir)
		(progn (mhg-file-to folder)
		       (throw 'finish nil))))))

    (cond ((or (mhg-hdr-regexp
		subject "Engelbart\\|\\<\\(AUGMENT\\|NLS\\)\\>\\|bootstrap")
	       (mhg-hdr-regexp
		from "\\(dce\\|mac\\)@sunrise\\|billd@informix")
	       (mhg-hdr-regexp
		to "\\(dce\\|mac\\)@sunrise\\|billd@informix"))
	   (mhg-file-to "engelbart"))
	  ((or (mhg-hdr-regexp from "mot\\.com\\|codex\\.com")
	       (mhg-hdr-string subject "Motorola"))
	   (cond ((mhg-hdr-regexp
		   subject
		   (concat "info\\(rmation\\)?\\( technology\\)? framework"
			   "\\|IT \\(lab\\|group\\)"
			   "\\|staffing\\|personnel"))
		  (mhg-file-to "mot/info-tech"))
		 (t (mhg-file-to "mot/misc"))
		 )))

    (cond
     ((or (mhg-hdr-string to "hyperbole-request")
	  (mhg-hdr-string subject "hyperbole@cs.brown.edu"))
      (mhg-file-to "hypb/request"))
     ((or (mhg-hdr-string to "hyperbole")
	  (mhg-hdr-regexp
	   subject
	   (concat "hyperb\\|hypb\\|link\\|actype\\|ibtype"
		   "\\|\\(button\\|action\\) type")))
      (mhg-file-to
       (concat
	"hypb/"
	(cond ((mhg-hdr-regexp
		subject "\\(Re: +\\)?\\(Add\\|Change\\Remove\\)" "hyperbole")
	       "request")
	      ((mhg-hdr-string subject "?") "question")
	      ((mhg-hdr-regexp subject "bug\\|problem\\|error") "bug")
	      ((mhg-hdr-regexp
		subject
		"idea\\|suggestion\\|improve\\|feature\\|facility\\|better")
	       "idea")
	      ((mhg-hdr-regexp
		subject
		(concat "\\<\\(VM\\|MH\\|MH-e\\)\\>\\|mail"
			"\\|USENET\\|netnews\\|GNUS"))
	       "mail-or-news")
	      ((mhg-hdr-regexp "report\\|paper\\|manual\\|\\<doc\\|DEMO")
	       "doc")
	      (t "misc")
	      ))))
     ((mhg-hdr-regexp
       subject
       (concat "hyper\\|IBIS\\>\\|\\<\\(GERM\\|PlaneText\\|NoteCards\\|Mac Guide"
	       "\\|\\(U of Kent\\|Mac\\|UNIX\\) Guide\\|Xanadu\\|WWW"
	       "\\|DynaText\\|DText\\|ebt\\|electronic book\\|Ted Nelson"
	       "MCC.+software\\)\\>"))
      (mhg-file-to "hyper"))
     ((mhg-hdr-regexp
       subject
       (concat
	"\\<PIE'?s?\\>\\|personal.+information\\|groupware"
	"\\|personalized\\|personalization\\|information environment"
	"\\|info.+\\(framework\\|research\\)"))
      (mhg-file-to "pie"))
     ((or (mhg-hdr-regexp
	   subject
	   (concat "\\<\\(VM\\|MH\\|MH-e\\|X\\.?[45]00\\|SMTP\\|sendmail\\)\\>"
			"\\|mail\\|USENET\\|netnews\\|GNUS"))
	  (mhg-hdr-string subject "address" "list"))
      (mhg-file-to "mail-or-news"))
     ((or (mhg-hdr-regexp
	   subject
	   (concat "keyboard\\|mouse\\|chord\\|menu\\|button\\|winterp"
		   "human factor\\|rules? of thumb\\|heuristic"))
	  (mhg-hdr-string to "winterp")
	  (mhg-hdr-string to "human-factor"))
      (mhg-file-to "ui"))
     ((mhg-hdr-regexp subject "agent\\|knowbot")
      (mhg-file-to "agent"))
    ((mhg-hdr-regexp subject "data ?base\\|relational\\|perl\\|\\<r?db\\>")
     (mhg-file-to "database"))
    ((mhg-hdr-regexp
      subject "\\<\\(IR\\|IRLIST\\|WAIS\\)\\>\\|info.+retrieval\\|full text")
     (mhg-file-to "ir"))
     )
    
    (cond ((mhg-hdr-regexp
	    subject
	    "emacs\\|elisp\\e-lisp\\|-mode\\|tags\\|superman\\|supercite")
	   (mhg-file-to "emacs"))
	  ((mhg-hdr-regexp subject "oobr\\|\\<x?br-\\|browser\\|object.*browse")
	   (mhg-file-to "oobr"))
	  ((or (mhg-hdr-string to "sather")
	       (mhg-hdr-string subject "sather"))
	   (mhg-file-to "sather"))
	  ((mhg-hdr-string subject "eiffel")
	   (mhg-file-to "eiffel"))
	  ((mhg-hdr-regexp
	    subject (concat "Omtool\\|object[- ]\\(oriented\\|based\\)"
			    "\\|abstract data"))
	   (mhg-file-to "oo"))
	  ((mhg-hdr-regexp subject "scheme\\|lisp\\|CLOS")
	   (mhg-file-to "lisp"))
	  ((or (mhg-hdr-regexp
		subject "\\<\\(C\\|C\\+\\+\\)\\>\\|Stroustrup\\|Koenig")
	       (mhg-hdr-regexp
		from "\\<\\(C\\|C\\+\\+\\)\\>\\|Stroustrup\\|Koenig"))
	   (mhg-file-to "C-or-C++"))
	  ((or (mhg-hdr-string subject "ange-ftp")
	       (mhg-hdr-string to "ange-ftp")
	       (mhg-hdr-string from "ange@"))
	   (mhg-file-to "ange-ftp"))
	  ((or (mhg-hdr-regexp subject "gnu\\|FSF\\|free software")
	       (mhg-hdr-string from "gnu"))
	   (mhg-file-to "gnu")))

    (if (mhg-hdr-string subject "rolo") (mhg-file-to "rolo"))
    
    (if (mhg-hdr-string subject "smart") (mhg-file-to "smart"))
    
    (if (mhg-hdr-regexp
	 subject
	 (concat "\\<pen\\([- ]?\\(point\\|windows\\|centric\\)\\)?\\>"
		 "\\|\\<GO Corp"
		 "\\|portable \\(radio\\|data\\|computer\\|unit\\)"))
	(mhg-file-to "pen"))

    (if (or (mhg-hdr-string to "clips")
	    (mhg-hdr-regexp
	     subject (concat "clips\\|\\<COSMIC\\>\\|knowledge[- ]based"
			     "\\|production sys\\|expert sys"))
	    (mhg-hdr-string from "cosmic"))
	(mhg-file-to "expert"))

    (if (mhg-hdr-regexp subject "modem\\|dialup\\|dialin\\|ACE card")
	(mhg-file-to "modem"))

    (if (mhg-hdr-regexp
	 subject "\\<\\(yacc\\|lex\\|sed\\|unix\\|[a-z]sh\\|awk\\)\\>")
	(mhg-file-to "unix"))

    (cond ((mhg-hdr-regexp subject "\\<\\(IPP\\|Brown\\|Brounonian\\)\\>")
	   (mhg-file-to "brown"))
	  ((or (mhg-hdr-string subject "IEEE")
	       (mhg-hdr-string from "ieee.org"))
	   (mhg-file-to "ieee"))
	  ((or (mhg-hdr-regexp subject "\\<C?ACM\\>")
	       (mhg-hdr-string from "acm.org"))
	   (mhg-file-to "acm"))
	  )

    (cond
     ((mhg-hdr-regexp subject "\\<X\\|xwindow\\|motif")
      (mhg-file-to "xwindows"))
     ((mhg-hdr-regexp
	 subject
	 (concat "\\<\\(ftp\\|\\(hy\\)?telnet\\|internet\\|wide[- ]area net"
		 "\\|RFC\\|arpanet\\|nsfnet\\|suranet\\)\\>"))
      (mhg-file-to "internet"))
     ((mhg-hdr-regexp
       subject
       (concat "patent\\|innovat\\|invent\\|intellectual property"
	       "\\|ownership\\|copyright\\|legal\\|law\\|own info"))
      (mhg-file-to "sun"))
     ((mhg-hdr-regexp
       subject
       (concat "\\<\\(ipc\\|tooltalk\\|client\\|server\\)\\>"
	       "\\|\\<\\(inter[- ]?\\(app\\|proc\\)\\)"))
      (mhg-file-to "ipc"))
     ((mhg-hdr-regexp subject "\\<\\(mac\\|macintosh\\|apple\\)\\>")
      (mhg-file-to "apple"))
     ((mhg-hdr-regexp
       subject "\\<\\(sun\\|sparc\\|openlook\\|openwindows\\)\\>")
      (mhg-file-to "sun"))
     ((mhg-hdr-regexp subject "\\<\\(mac\\|macintosh\\|apple\\)\\>")
      (mhg-file-to "hp"))
     )

    (or mhg-filed-to (mhg-file-to "misc"))
    ))

    (if (interactive-p)
	(message "Auto file msg to: %s" mhg-filed-to)
      (princ subject) (terpri)
      (princ "  ") (princ mhg-filed-to)
      (terpri) (terpri)
      mhg-filed-to)
    ))
