/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 */


#include <stdio.h>

char *malloc();

/*

Stdin has things like:

Host cica.cica.indiana.edu

    Location: /pub
      DIRECTORY drwxr-xr-x        512  Jul 31 23:39  graphics

Host cs.orst.edu

    Location: /pub/next
      DIRECTORY drwxr-xr-x       1024  Jul 12 12:13  graphics
    Location: /pub/next/sources
      DIRECTORY drwxr-xr-x       1024  Aug  1 17:02  graphics

---------------------------------------------------------------------
And this program puts to stdout things like:

/alex/edu/indiana/circa/circa/pub/graphics
     DIRECTORY drwxr-xr-x        512  Jul 31 23:39  graphics

/alex/edu/orst/cs/pub/next/graphics
      DIRECTORY drwxr-xr-x       1024  Jul 12 12:13  graphics

/alex/edu/orst/cs/pub/next/sources/graphics
      DIRECTORY drwxr-xr-x       1024  Aug  1 17:02  graphics

*/


/*  Input:     "sam.cs.cmu.edu"
 *  Returns:   "/edu/cmu/cs/sam"
 *  Destructive operation
 */
int NameToPath(namepath)
char *namepath;
{
    char LIFO[20][100];
    int length, seg, outi, cur, onlyonepart;

    seg=0;
    outi=0;
    onlyonepart=0;

    length=strlen(namepath);

    for (cur=0; cur<length; cur++) {
        if (namepath[cur] == '.') {
            LIFO[seg][outi]=NULL;
            seg++;
            outi=0;
        } else {
            LIFO[seg][outi]=namepath[cur];
            outi++;
        }
    }
    LIFO[seg][outi]=NULL;

    if (seg==0) onlyonepart=1;

    cur=0;
    for (; seg>=0; seg--) {
        namepath[cur++]='/';
        strcpy(&namepath[cur], LIFO[seg]);
        cur += strlen(LIFO[seg]);
    }
    namepath[cur]=NULL;

    return(onlyonepart);
}


GetLastToken(ins, outs)
char *ins, *outs;
{
    char *s;

    for(s=ins; (s != NULL) && (*s != 0); s++) {
        ;
    }
    for( ; (s != NULL) && (*s != ' '); s--) {
        ;
    }
    s++;
    for (; (s!= NULL) && (*s != 0); s++) {
        *outs = *s;
         outs++;
    }
    outs=0;
}

NoDoubleSlash(s)
char *s;
{
    char *s2;

    for (; (s != NULL) && (*s != 0); s++) {
        if ((s[0] == '/') && (s[1] == '/')) {
            for (s2=s; (s2 != NULL) && (*s2 != 0); s2++) {
                s2[0]=s2[1];
            }
        }
    }
}

#define AHOST      "Host"
#define ALOCATION  "Location:"
#define AFILE      "FILE"
#define ADIRECTORY "DIRECTORY"
main()
{
    int i;
    char Host[200], Dir[200], File[200];
    char line[200], tmp[300];
   
    Host[0]=0;
    Dir[0]=0;
    File[0]=0;
 
    while (gets(line) != NULL) {
        for (i=0; (i<strlen(line)) && (line[i] == ' '); i++) {
            ;
        }
        if (strlen(&line[i]) > 1) {
            if (0 == strncmp(&line[i], AHOST,      strlen(AHOST))) {
                strcpy(Host, &line[i+strlen(AHOST)+1]);
                NameToPath(Host);
            } else if (0 == strncmp(&line[i], ALOCATION, strlen(ALOCATION))) {
                        strcpy(Dir, &line[i+strlen(ALOCATION)+1]); 
            } else if ((0 == strncmp(&line[i], ADIRECTORY,  strlen(ADIRECTORY))) ||
                       (0 == strncmp(&line[i], AFILE,       strlen(AFILE)))) {
                if (Host[0]==0) {
                    fprintf(stderr, "No host name for this file\n");
                }
                if (Dir[0]==0) {
                    fprintf(stderr, "Did not see an archie Location (directory)\n");
                }
                GetLastToken(line, File);
                sprintf(tmp, "/alex%s%s/%s", Host, Dir, File);
                NoDoubleSlash(tmp);
                printf("%s\n", tmp);
                printf("%s\n\n",line);
            } else {
                fprintf(stderr, "archiefilter hates this input\n");
            }
        }
    }
} 

            

