.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH SHOW %manext1% MH.6.8 [%nmhversion%]
.SH NAME
show \- show (display) messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
show
\%[+folder] \%[msgs]
\%[\-draft]
\%[\-header] \%[\-noheader]
.br
\%[\-showproc\ program] \%[\-noshowproc]
.br
\%[switches\ for\ \fIshowproc\fR]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIShow\fR lists each of the specified messages to the standard output
(typically, the terminal).  Typically, the messages are listed exactly as
they are, with no reformatting.  A program named by the \fIshowproc\fR
profile component is invoked to do the listing, and any switches not
recognized by \fIshow\fR are passed along to that program.  The default
program is known as \fImore\fR\0(1).  To override the default and the
\fIshowproc\fR profile component, use the `\-showproc\ program' switch.
For example, `\-show\ pr' will cause the \fIpr\fR\0(1) program to
list the messages.  The \fInmh\fR command \fImhl\fR can be used as a
\fIshowproc\fR to show messages in a more uniform format.  Normally, this
program is specified as the \fIshowproc\fR in the user's \&.mh\(ruprofile.
See \fImhl\fR\0(1) for the details.  If the `\-noshowproc' option is
specified, `/bin/cat' is used instead of \fIshowproc\fR.

If you have messages with multi-media contents (MIME messages), the
profile entry \fImhnproc\fR defines the name of a program to manipulate
multi-media messages.  (The \fImhn\fR\0(1) program, which is suitable
for this purpose, is the default.)  If the `\-noshowproc' option is
NOT specified, and if one or more named messages has a multi-media
content, then the program indicated by \fImhnproc\fR will be run instead
of \fIshowproc\fR.  The use of the \fImhnproc\fR can also be disabled
if the environment variable \fBNOMHNPROC\fR is set.  Note that the
\fImhnproc\fR may be invoked even for textual contents, depending on the
character set involved.  The environment variable MM_CHARSET should be
set to the terminal's character set to avoid gratuitous invocations of
the \fImhnproc\fR.

The `\-header' switch tells \fIshow\fR to display a one\-line description
of the message being shown.  This description includes the folder and
the message number.

If no `msgs' are specified, the current message is used.  If more than
one message is specified, \fImore\fR will prompt for a <RETURN> prior
to listing each message.  \fImore\fR will list each message, a page at
a time.  When the end of page is reached, \fImore\fR will ring the bell
and wait for a <SPACE> or <RETURN>.  If a <RETURN> is entered, \fImore\fR
will print the next line, whereas <SPACE> will print the next screenful.
To exit \fImore\fR, type \*(lqq\*(rq.

If the standard output is not a terminal, no queries are made, and each
file is listed with a one\-line header and two lines of separation.

\*(lqshow \-draft\*(rq will list the file <mh\-dir>/draft if it exists.

If the profile entry \*(lqUnseen\-Sequence\*(rq is present and
non\-empty, then \fIshow\fR will remove each of the messages shown
from each sequence named by the profile entry.  This is similar to the
\*(lqPrevious\-Sequence\*(rq profile entry supported by all \fInmh\fR
commands which take `msgs' or `msg' arguments.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Unseen\-Sequence:~^To name sequences denoting unseen messages
.Ps
^showproc:~^Program to show non-MIME messages
.Ps
^mhnproc:~^Program to show MIME messages
.Sa
mhl(1), more(1), next(1), pick(1), prev(1), scan(1)
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-header'
.Co
If a folder is given, it will become the current folder.  The last
message shown will become the current message.
.Bu
The `\-header' switch doesn't work when `msgs' expands to more than
one message.  If the \fIshowproc\fR is \fImhl\fR, then is problem can
be circumvented by referencing the \*(lqmessagename\*(rq field in the
\fImhl\fR format file.

\fIShow\fR updates the user's context before showing the message.
Hence \fIshow\fR will mark messages as seen prior to the user actually
seeing them.  This is generally not a problem, unless the user relies
on the \*(lqunseen\*(rq messages mechanism, and interrupts \fIshow\fR
while it is showing \*(lqunseen\*(rq messages.

If \fIshowproc\fR is \fImhl\fR, then \fIshow\fR uses a built\-in
\fImhl\fR: it does not actually run the \fImhl\fR program.  Hence, if you
define your own \fIshowproc\fR, don't call it \fImhl\fR since \fIshow\fR
won't run it.

If \fImore\fR\0(1) is your showproc (the default), then avoid running
\fIshow\fR in the background with only its standard output piped to
another process, as in

.ti +.5i
show | imprint &

Due to a bug in \fImore\fR, show will go into a \*(lqtty input\*(rq state.
To avoid this problem, re\-direct \fIshow\fR's diagnostic output as well.
For users of \fIcsh\fR:

.ti +.5i
show |& imprint &

For users of \fIsh\fR:

.ti +.5i
show 2>&1 | imprint &
.En
