.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH FLIST %manext1% MH.6.7 [%nmhversion%]
.SH NAME
flist \- list folders that contain messages in given sequence
.SH SYNOPSIS
.in +.5i
.ti -.5i
flist
\%[+folder1 [+folder2 ...]]
\%[\-sequence\ name]
\%[\-all] \%[\-noall]
\%[\-alpha] \%[\-noalpha]
\%[\-recurse] \%[\-norecurse]
\%[\-total] \%[\-nototal]
\%[\-version]
\%[\-help]

.in -.5i
.SH DESCRIPTION
This program lists those folders that contain messages in a given
sequence.  The option `\-sequence' is used to specify the name of the
sequence to search for.  If this is not given, then the default is to
search for the sequence specified by the "Unseen-Sequence" profile
component.  This is especially useful if you use some mechanism
such as \fIslocal\fP or \fIprocmail\fP (usually in conjunction with
\fIrcvstore\fP) to pre-sort your mail into different folders before you
view it.

\fIFlist\fR will list those top level folders containing the given
sequence, and for each folder displayed, it will output the number of
messages that are in the given sequence and the total number of messages.
If folders are specified on the command line with `+folder', then only
those folders are search for the given sequence.

An example of the output is:

.nf
.if t .in +.5i
.ta \w'/rnd/phyl/Mail/EP 'u +\w'ddd 'u +\w'new out of 'u +\w'ddd 'u
+inbox          8 in sequence unseen, out of 153
+junklist       2 in sequence unseen, out of  63
+postmaster     1 in sequence unseen, out of   3
.re
.if t .in -.5i
.fi

Specifying `\-all' will produce a line for each folder in the user's nmh
directory.  If `\-recurse' is given, then \fIflist\fR will recursively
search subfolders for the given sequence.

If `\-nototal' is given, only the names of the folders containing the
given sequence (or the names of all the folders in the case of `\-all')
will be displayed, and will suppress the output of the total number of
messages in the folder.

The sorting order for the listing is alphabetical (with '\-alpha'),
or in a priority order defined by the Flist-Order profile entry
(with '\-noalpha').  Each item in the Flist-Order is a folder name
or a folder name pattern that uses * to match zero or more characters.
Longer matching patterns have precedence over shorter matching patterns.
For example:

.nf
Flist-Order: personal petproject mh* * admin *junk
.fi

This order puts a few interesting folders first, such as those with mail
addressed to you personally, those about a pet project, and those about
mh-related things.  It shoves uninteresting folders to the end, and it
puts everything else in the middle in alphabetical order.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Unseen-Sequence:~^The name of the unseen message sequence
.Ps
^Flist-Order:~^To sort folders by priority
.Sa
folder(1), procmail(1), rcvstore(1), slocal(1)
.De
`\-noall'
.Ds
`\-noalpha'
.Ds
`\-norecurse'
.Ds
`\-total'
.En
