
/*
 * mhpath.c -- print full pathnames of nmh messages and folders
 *
 * $Id$
 */

#include "../h/mh.h"

static struct swit switches[] = {
#define VERSIONSW 0
    { "version", 0 },
#define	HELPSW	1
    { "help", 4 },
    { NULL, 0 }
};


main(int argc, char **argv)
{
    int msgp = 0, msgnum;
    char *cp, *maildir, *folder = NULL, buf[100];
    char **ap, **argp, *arguments[MAXARGS], *msgs[MAXARGS];
    struct msgs *mp;

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while (cp = *argp++) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

    if (!m_find ("path"))
	free (path ("./", TFOLDER));

    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);
    if (!msgp) {
	printf ("%s\n", maildir);
	done (0);
    }

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);

    if ((mp = m_remsg (mp, 0, MAXFOLDER)) == NULL)
	adios (NULL, "unable to allocate folder storage");
    mp->msgflags |= MHPATH;

    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done (1);
    m_setseq (mp);

    if (mp->numsel > MAXARGS - 2)
	adios (NULL, "more than %d messages", MAXARGS - 2);

    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
	if (mp->msgstats[msgnum] & SELECTED)
	    printf ("%s/%s\n", mp->foldpath, m_name (msgnum));

    m_sync (mp);
    m_update ();
    done (0);
}
