
/*
 * signals.c -- general signals interface for nmh
 *
 * $Id$
 */

#include "../h/mh.h"


int
SIGPROCMASK (int how, const sigset_t *set, sigset_t *oset)
{
#ifdef POSIX_SIGNALS
    return sigprocmask(how, set, oset);
#else
# ifdef BSD_SIGNALS
    switch(how) {
    case SIG_BLOCK:
	*oset = sigblock(*set);
	break;
    case SIG_UNBLOCK:
	sigfillset(*oset);
	*oset = sigsetmask(*oset);
	sigsetmask(*oset & ~(*set));
	break;
    case SIG_SETMASK:
	*oset = sigsetmask(*set);
	break;
    default:
	adios(NULL, "unknown flag in SIGPROCMASK");
	break;
    }
    return 0;
# endif
#endif
}

