
/*
 * push.c -- push a fork into the background
 *
 * $Id$
 */

#include "../h/mh.h"
#include <signal.h>


void
push(void)
{
    register int i;

    for (i = 0; i < 5; i++) {
	switch (fork ()) {
	    case NOTOK: 
		sleep (5);
		continue;

	    case OK: 
		signal (SIGHUP, SIG_IGN);
		signal (SIGINT, SIG_IGN);
		signal (SIGQUIT, SIG_IGN);
		signal (SIGTERM, SIG_IGN);
#ifdef SIGTSTP
		signal (SIGTSTP, SIG_IGN);
		signal (SIGTTIN, SIG_IGN);
		signal (SIGTTOU, SIG_IGN);
#endif	/* SIGTSTP */
		freopen ("/dev/null", "r", stdin);
		freopen ("/dev/null", "w", stdout);
		break;

	    default: 
		done (0);
	}
	break;
    }
    if (i >= 5)
	advise (NULL, "unable to fork, so can't push...");
}
