
/*
 * termsbr.c -- termcap support
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	/* lint */

#include "../h/nmh.h"
#include "../h/mh.h"

#ifdef SYS5
# include <sys/types.h>
# include <sys/ioctl.h>
#endif

#ifdef HAVE_TERMIOS_H
# include <termios.h>
#else
# ifdef HAVE_TERMIO_H
#  include <termio.h>
# else
#  include <sgtty.h>
# endif
#endif

#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#endif

#if BUFSIZ<2048
# define TXTSIZ	2048
#else
# define TXTSIZ BUFSIZ
#endif

/* Need to fix this */
#ifdef SYS5
extern short ospeed;
extern char PC;
#endif

/*
 * These variables are sometimes defined in,
 * and needed by the termcap library.
 */
#ifdef MUST_DEFINE_OSPEED
extern short ospeed;
extern char PC;
#endif

static int  HC = 0;

static int  initLI = 0;
static int  LI = 40;
static int  initCO = 0;
static int  CO = 80;
static char *CL = NULL;
static char *SE = NULL;
static char *SO = NULL;

static char termcap[TXTSIZ];


static
read_termcap(void)
{
    register char *bp, *term;
    char *cp, myterm[TXTSIZ];

#ifdef HAVE_TERMIOS_H
    struct termios tio;
#else
# ifdef HAVE_TERMIO_H
    struct termio tio;
# else
    struct sgttyb tio;
# endif
#endif

    static int inited = 0;

    if (inited++)
	return;

    if ((term = getenv ("TERM")) == NULL || tgetent (myterm, term) <= OK)
	return;

#ifdef HAVE_TERMIOS_H
    ospeed = cfgetospeed(&tio);
#else
# ifdef HAVE_TERMIO_H
    ospeed = ioctl(fileno(stdout), TCGETA, &tio) != NOTOK ? tio.c_cflag & CBAUD : 0;
# else
    ospeed = ioctl(fileno(stdout), TIOCGETP, (char *) &tio) != NOTOK ? tio.sg_ospeed : 0;
# endif
#endif

    HC = tgetflag ("hc");

    if (!initCO && (CO = tgetnum ("co")) <= 0)
	CO = 80;
    if (!initLI && (LI = tgetnum ("li")) <= 0)
	LI = 24;

    cp = termcap;
    CL = tgetstr ("cl", &cp);
    if (bp = tgetstr ("pc", &cp))
	PC = *bp;
    if (tgetnum ("sg") <= 0) {
	SE = tgetstr ("se", &cp);
	SO = tgetstr ("so", &cp);
    }
}


int
sc_width (void)
{
#ifdef TIOCGWINSZ
    struct winsize win;
    int width;

    if (ioctl (fileno (stderr), TIOCGWINSZ, &win) != NOTOK
	    && (width = win.ws_col) > 0) {
	CO = width;
	initCO++;
    } else
#endif /* TIOCGWINSZ */
	read_termcap();

    return CO;
}


int
sc_length (void)
{
#ifdef TIOCGWINSZ
    struct winsize win;

    if (ioctl (fileno (stderr), TIOCGWINSZ, &win) != NOTOK
	    && (LI = win.ws_row) > 0)
	initLI++;
    else
#endif /* TIOCGWINSZ */
	read_termcap();

    return LI;
}


static int
outc (int c)
{
    putchar(c);
}


void
clear_screen (void)
{
    read_termcap ();

    if (CL && ospeed)
	tputs (CL, LI, outc);
    else {
	printf ("\f");
	if (ospeed)
	    printf ("\200");
    }

    fflush (stdout);
}


int
SOprintf (char *fmt, char *a, char *b, char *c, char *d, char *e, char *f)
{
    read_termcap ();
    if (SO == NULL || SE == NULL)
	return NOTOK;

    tputs (SO, 1, outc);
    printf (fmt, a, b, c, d, e, f);
    tputs (SE, 1, outc);

    return OK;
}

int
sc_hardcopy(void)
{
    read_termcap();

    return HC;
}
