
/*
 * m_update.c -- update the profile
 */

#ifndef	lint
static char ident[] = "$Id$";
#endif	lint

#include "../h/nmh.h"
#include "../h/mh.h"
#include <stdio.h>
#include "../h/signals.h"

/*
 * static prototypes
 */
static int m_chkids(void);


void
m_update(void)
{
    int action;
    register struct node *np;
    FILE * out;
    sigset_t set, oset;

    if (!(ctxflags & CTXMOD))
	return;
    ctxflags &= ~CTXMOD;

    if ((action = m_chkids ()) > OK)
	return;			/* child did it for us */

    /* block a few signals */
    sigemptyset (&set);
    sigaddset (&set, SIGHUP);
    sigaddset (&set, SIGINT);
    sigaddset (&set, SIGQUIT);
    sigaddset (&set, SIGTERM);
    SIGPROCMASK (SIG_BLOCK, &set, &oset);

    if ((out = fopen (ctxpath, "w")) == NULL)
	adios (ctxpath, "unable to write");
    for (np = m_defs; np; np = np->n_next)
	if (np->n_context)
	    fprintf (out, "%s: %s\n", np->n_name, np->n_field);
    fclose (out);

    SIGPROCMASK (SIG_SETMASK, &oset, &set); /* reset the signal mask */

    if (action == OK)
	_exit (0);		/* we are child, time to die */
}

/*
 * This hack brought to you so we can handle set[ug]id MH programs.
 * If we return NOTOK, then no fork is made, we update .mh_profile
 * normally, and return to the caller normally.  If we return 0,
 * then the child is executing, .mh_profile is modified after
 * we set our [ug]ids to the norm.  If we return > 0, then the
 * parent is executed and .mh_profile has already be modified.
 * We can just return to the caller immediately.
 */

static int
m_chkids (void)
{
    int i, child_id;

    if (getuid () == geteuid ())
	return (NOTOK);

    for (i = 0; (child_id = fork ()) == -1 && i < 5; i++)
	sleep (5);
    switch (child_id) {
	case NOTOK:
	    break;

	case OK:
	    setgid (getgid ());
	    setuid (getuid ());
	    break;

	default:
	    pidwait (child_id, NOTOK);
	    break;
    }

    return child_id;
}
