#
# convert/mailtool.tcl
#
# Default template for SUN mailtool mailers

proc sun_type {} {
	set TYPE [gettype]
	if {[set SUBTYPE [getsubtype]] == 0} {
		set SUBTYPE "Unknown"
	}

	case $TYPE in {
		TEXT {
			addheader "X-Sun-Data-Type" "text"
			addheader "X-Sun-Data-Description" "text"
			do_decode
			tocharset "LATIN1"
		}
		APPLICATION {
			addheader "X-Sun-Data-Type" "default-app"
			addheader "X-Sun-Data-Description" $SUBTYPE
			addheader "X-Sun-Encoding-Info" "uuencode"
			do_code "UUENCODE"
		} 
		IMAGE {
			if {$SUBTYPE == "GIF"} {
				addheader "X-Sun-Data-Type" "gif-file"
			} \
			else {
				addheader "X-Sun-Data-Type" "default"
			}
			addheader "X-Sun-Data-Description" $SUBTYPE
			addheader "X-Sun-Encoding-Info" "uuencode"
			do_code "UUENCODE"
		}

		AUDIO {
			if {$SUBTYPE == "ULAW"} {
				addheader "X-Sun-Data-Type" "audio-file"
			} \
			else {
				addheader "X-Sun-Data-Type" "default"
			}
			addheader "X-Sun-Data-Description" $SUBTYPE
			addheader "X-Sun-Encoding-Info" "uuencode"
			do_code "UUENCODE"
		}


		BINHEX {
			addheader "X-Sun-Data-Type" "text"
			addheader "X-Sun-Data-Type" "default"
			addheader "X-Sun-Data-Description" \
				"BinHex file with resource fork"
		}

		APPLESINGLE {
			addheader "X-Sun-Data-Type" "default"
			addheader "X-Sun-Encoding-Info" "uuencode"
			addheader "X-Sun-Data-Description" \
				"AppleSingle File"
			do_code "UUENCODE"
		}

		MULTIPART {
			set junk "MULTIPART"
			}

		default {
			addheader "X-Sun-Data-Type" "default"
			addheader "X-Sun-Data-Description" $SUBTYPE
			addheader "X-Sun-Encoding-Info" "uuencode"
			do_code "UUENCODE"
		}
	}
	joinextension
	set NAME [getfilename]
	if {$NAME != "0"} {
		addheader "X-Sun-Data-Name" "$NAME"
	} \
	else \
	{
		if {$TYPE == "TEXT"} {
			addheader "X-Sun-Data-Name" "text"
		}
	}
	
}
proc do_multi {} {
	global BOUNDARY
	set BOUNDARY "----------"
	dosubheaders
	addboundary "$BOUNDARY"
}

topmessnode

if {[is_multipart] < 1} {
	set MMAIN [gettype]
	debug "No multipart"
} \
else \
{
	set MMAIN "MULTIPART"
	do_multi
	debug "Multipart"
}



topmessnode	
while {1 == 1} {
	rmspecheader
	if {[is_root]} {
		if {$MMAIN == "MULTIPART"} {
			addheader "Content-Type" \
				"X-sun-attachment"
		} \
		else \
		{
			if {$MMAIN == "TEXT"} {
				addheader "Content-Type" "text"
			} \
			else \
			{
				addheader "Content-Type" \
					"X-sun-attachment"
				do_multi
				sun_type
			}
		}
	} \
	else \
	{
		if {[hasbody]} {
			sun_type
		} \
		else {
			debug "MAILTOOL: No Body"
		}
	}
	set A [nextmessnode]
	if {$A < 1} {
		break
	}
}

debug "convert/mailtool.tcl done"
