/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */







#include "mk.h"

/*
 * Array of Emil's TCL-commands and their corresponding functions.
 */

static FuncStruct  mkconverters[] = {
	/* Commands */ 
	{"debug", 		Mk_Debug},
	{"is_root", 		Mk_IsRoot},
	{"is_multipart",	Mk_IsMulti},
	{"to7bit", 		Mk_To7Bit},
	{"tocharset",		Mk_ToCharset},
	{"setfromcharset",      Mk_SetFromCharset},
	{"setfromesc",          Mk_SetFromEsc},
	{"is_set",              Mk_IsSet},
	{"getextension",        Mk_GetExtension},
	{"setextension",        Mk_SetExtension},
	{"getfilename",         Mk_GetFilename},
	{"setfilename",         Mk_SetFilename},
	{"joinextension",       Mk_JoinExtension},
	{"getbinhextype",       Mk_GetBinHexType},
	{"setbinhextype",       Mk_SetBinHexType},
        {"getbinhexauth",       Mk_GetBinHexAuth},
	{"setbinhexauth",       Mk_SetBinHexAuth},
	{"makeboundary",        Mk_MakeBoundary},
	{"putendboundary",      Mk_PutEndBoundary},
	{"addboundary",         Mk_AddBoundary},
	{"addendboundary",      Mk_AddEndBoundary},
	{"setcheck",            Mk_SetCheck},
	{"encode",              Mk_Encoding},
	{"decode",              Mk_Decoding},
	{"getencoding",		Mk_GetEncoding},
	{"setencoding",		Mk_SetEncoding},
	{"gettype",		Mk_GetType},
	{"settype",		Mk_SetType},
	{"getsubtype",		Mk_GetSubType},
	{"setsubtype",		Mk_SetSubType},
	{"setmaintype",         Mk_SetMainType},
	{"getmaintype",         Mk_GetMainType},
	{"getheader",           Mk_Getheader},
	{"hasbody",             Mk_HasBody},
	{"killbody",            Mk_KillBody},
	{"nextmessnode",	Mk_NextMessNode},
	{"insertmessnode",	Mk_InsertMessNode},
	{"topmessnode",		Mk_TopMessNode},
	{"listheaders",         Mk_ListHeaders},
	{"addheader",           Mk_AddHeader},
	{"addspecheader",       Mk_AddSpecHeader},
	{"rmheader",            Mk_RmHeader},
	{"rmspecheader",        Mk_RmSpecHeader},
	{"dosubheaders",        Mk_DoSubHeaders},
	{"dotunnel",            Mk_DoTunnel},
	{"gethighchars",        Mk_GetHighChars},
	{"knowfromcharset",    Mk_KnowFromCharset},
	{(char *)NULL,          (int (*)())NULL}
};




/* 
 * Initialize the main action data structures, conversion tables etc.
 */

int
Mk_InitAction()
{
  int i, n;
  char	*abuf;
  abuf = newstr(MIME_CHARSET);
  local_mime_charset = getchset(abuf, 29);
  free(abuf);

  bzero(ISO_TO_QP, 256);
  for (i = 33; i < 127; i++) 
    if (i != 61)
      ISO_TO_QP[i] = i;
  
  bzero(ISO_TO_7BIT, 256);
  ISO_TO_7BIT[0] = '#';
  for (i = 1; i < 128; i++)
    ISO_TO_7BIT[i] = i;
  strcat(ISO_TO_7BIT,"                                ");
  strcat(ISO_TO_7BIT," !$$$$|&\"C <--R^ +23'  *,1 >   ?");
  strcat(ISO_TO_7BIT,"AAAA[][CE@EEIIIIDNOOOO\\x\\UUU^YPB");
  strcat(ISO_TO_7BIT,"aaaa{}{ce`eeiiiidnoooo| |uuu~ypy");



  bzero(BASE64_TO_8BIT, 256);
  for (i = 'A'; i <= 'Z'; i++)
    BASE64_TO_8BIT[i] = i - 'A';
  for (i = 'a'; i <= 'z'; i++)
    BASE64_TO_8BIT[i] = i - 71;
  for (i = '0'; i <= '9'; i++)
    BASE64_TO_8BIT[i] = i + 4;
  BASE64_TO_8BIT['+'] = 62;
  BASE64_TO_8BIT['/'] = 63;

  for (i = 0; i < 26; i++)
    BASE64[i] = (char)i + 'A';
  for (; i < 52; i++)
    BASE64[i] = i - 26 + 'a';
  for (; i < 62; i++)
    BASE64[i] = i - 4;
  BASE64[62] = '+';
  BASE64[63] = '/';

  bzero(BinHex, 256);

  n = 0;
  for (i = '!'; i <= '-'; i++)
    BinHex[i] = n++;
  for (i = '0'; i <= '6'; i++)
    BinHex[i] = n++;
  BinHex['8'] = n++;
  BinHex['9'] = n++;
  for (i = '@'; i <= 'N'; i++)
    BinHex[i] = n++;
  for (i = 'P'; i <= 'V'; i++)
    BinHex[i] = n++;
  for (i = 'X'; i <= '['; i++)
    BinHex[i] = n++;
  for (i = '`'; i <= 'f'; i++)
    BinHex[i] = n++;
  for (i = 'h'; i <= 'm'; i++)
    BinHex[i] = n++;
  for (i = 'p'; i <= 'r'; i++)
    BinHex[i] = n++;

  bzero(ToBinHex, 64);
  strcpy(ToBinHex, "!\"#$%&'()*+,-012");
  strcat(ToBinHex, "345689@ABCDEFGHI");
  strcat(ToBinHex, "JKLMNPQRSTUVXYZ[");
  strcat(ToBinHex, "`abcdefhijklmpqr");


  MkMess_Root = (MessageStruct *)mkmessalloc();
  MkMess_Curr = (MessageStruct *)MkMess_Root;

  MkMess_Buf =  MkMess_Root->buf;

  MkTcl_Root = MkMess_Root;
  MkTcl_Curr = MkMess_Curr;
  MkTcl_Buf = MkMess_Buf;
  linecount = 0;
  checkuuencode = FALSE;
  checkbinhex = FALSE;
}

/*
 * Top level initialisation.
 */
int
Mk_Tcl()
{
  FuncStruct *CmdPtr;
  interp = Tcl_CreateInterp();
  Mk_InitAction();
  
	for (CmdPtr= mkconverters; CmdPtr->name != NULL; CmdPtr++)
	  {
	    Tcl_CreateCommand(interp, CmdPtr->name, CmdPtr->func,
			      (ClientData) 0, (Tcl_CmdDeleteProc *)NULL);
	  }
  
}




