/* ************************************************************ *
 *								*
 *		CMD-INPUT.H					*
 *	Extern references to commands.				*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#include <varargs.h>
#ifndef __
# ifdef	__STDC__
#  define __(x) x
# else
#  define __(x) ()
# endif
#endif

struct headers {
  char *From;
  char *Reply;
  char *LReply;	/* lowercase normed reply for statistics analysis */
  char *OrigReply;
  char *MessageId;
  char *ReplyMsgId;
  char *Subject;
  int  BITNET;
  char *UFrom;
};

#define CMDARGCMD    struct command *Cmd
#define	CMDARGHDR    struct headers *Hdr
#define CMDARGOFIL   FILE *outfile
#define CMDARGS  __((CMDARGCMD,		\
		     char *argstr,	\
		     CMDARGHDR,		\
		     CMDARGOFIL))


struct command {
	char *name;
	int  (*Routine) CMDARGS;
	char *helpstr;
};


/* input.c */
extern int do_replyto CMDARGS;

/* cmds1.c */
extern int do_help  CMDARGS;
extern int do_pdget CMDARGS;
extern int do_pddir CMDARGS;

/* maillists.c */
extern int do_subscribe CMDARGS;
extern int do_unsubscribe CMDARGS;
extern int do_listmaillists CMDARGS;
extern int do_listreview CMDARGS;
extern int do_listrevme CMDARGS;

/* mailutil.c */
extern int Create_Mail_Header __((FILE *mailfile, CMDARGHDR, char *Subject,
				  char *MimeContentType,
				  char *MimeXferEncoding,
				  char *OurReference));
extern void do_sendmail __((FILE *mailfile, FILE *outfile));
extern void do_splitmail __((FILE *mailfile, FILE *outfile,
			     char *splitsize, char *prefix));
extern void do_mailpieces __((FILE *outfile, char *prefix));
extern int do_runsubproc __((FILE *mailfile, FILE *outfile, char *progpath,
			     char *argv0, ... ));

/* filecmds.c */
extern int do_partsize CMDARGS;
extern int do_encoding CMDARGS;
extern int do_chdir CMDARGS;
extern int do_locate CMDARGS;
extern char *PartBits;
extern int PartBitsCnt;
extern int do_parts CMDARGS;
extern int send_this_part __((const int partnum));
extern int mail_reply __((char *filename, CMDARGCMD, CMDARGHDR, CMDARGOFIL,
			  int linecount, char *Subject));
extern int do_filedir CMDARGS;
extern int do_shopmark CMDARGS;
extern int do_filesend CMDARGS;
extern int do_mailquota CMDARGS;

/* archie.c */
extern int do_archie CMDARGS;


/*  Commands are compiled from this file.. */
#include "cmds.h"
#include "proto.h"
