/* ************************************************************* *
 *	FastCd database maker for mailserver and ftp server	 *
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 * ************************************************************* */

#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#ifndef BSD
#include <fcntl.h>
#define S_ISDIR(mode)	((S_IFMT & (mode)) == S_IFDIR)
#endif
#include <ndbm.h>	/* For debug reporter... */

extern int OpenFastCdDBM();
extern int AddFastCdEntry();

extern void usage();

#define _FTP_HOME "/ftp"

main(argc,argv)
int argc;
char *argv[];
{
	FILE *input;
	char inpbuf[2048];
	char *inpline = inpbuf + sizeof(_FTP_HOME)-1;
	char *pp, *dirname;
	struct stat stats;

	if (argc != 2) usage();
	++argv;

	if (strcmp(*argv,"-")==0)
	  input = stdin;
	else
	  input = fopen(*argv,"r");

	OpenFastCdDBM(O_RDWR|O_CREAT|O_TRUNC);
	strcpy(inpline,_FTP_HOME);
	while (!feof(input) && !ferror(input)) {
	  *inpline = 0;
	  if (!fgets(inpline,sizeof(inpbuf)-sizeof(_FTP_HOME),input)) break;
	  if (!*inpline) break;
	  dirname = (char*)strrchr(inpline,'/');
	  if (!dirname) {
	    printf("A directory ? path without `/' in it!  `%s'\n",inpline);
	    continue;
	  }
	  ++dirname;		/* Skip heading `/' */
	  pp = (char*)strrchr(dirname,'\n');
	  if (pp) *pp = 0; /* Zap \n */
	  if (stat(inpbuf,&stats)) {
	    printf("`%s' is not recognized file/directory!\n",inpline);
	    continue;
	  }
	  if (!S_ISDIR(stats.st_mode)) {
	    printf("`%s' is not a directory, but is some other file system object\n");
	    continue;
	  }
/*fprintf(stderr,"%s\t%s\n",dirname,inpline);*/
	  if (AddFastCdEntry(dirname,inpline)) {
	    printf("AddFastCdEntry() failed ???  Kill me ??\n");
	  }
	}
	fclose(input);

	if (0) {
	  datum key,dat;
	  extern datum FCdDBMfirstkey(), FCdDBMnextkey(), FCdDBMfetch();

	  key = FCdDBMfirstkey();
	  while(key.dptr != NULL) {
	    dat = FCdDBMfetch(key);
	    key = FCdDBMnextkey();
	    if (*(char*)dat.dptr != '*')
	      printf("%s\n",dat.dptr);
	  }
	}
	return 0;
}


void
usage()
{
	printf("fastcdmaker - makes database for mailserver and FTP server fast CD commands.\n");
	printf("Expects to get ONE argument, name of input data text file, which\nshould contain ONLY names of directories in format `/pub/unix/...'\n");
	exit(1);
}
