/* ************************************************************ *
 *								*
 *		CMD-CMDS1					*
 *								*
 *	A part of main piece of mail (and other) servers.	*
#
#  Copyright 1990-1993   Matti.Aarnio @ FUNET.FI
#  This software is free under similar rules as BSD copyrights.
#  (Definitely this is NOT Public Domain.  "Just" FREELY AVAILABLE.
#   Don't clain you did this..)
#  You can use this, but you shall not held us liable for anything.
#  You must not use our name in marketing, in case you decide to
#  use this.  We do appreciate bug-reports  -> mailserver-owner@nic.funet.fi
#  for improving this piece of software.
 *								*
 * ************************************************************ */

#include <sys/param.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <fcntl.h>
#include <errno.h>
#include <dirent.h>


#include "config.h"
#include "input.h"

extern char *strchr();
extern char *malloc();
extern void  free();
extern int  errno;
extern char *sys_errlist[];
extern void usage();
extern int  process_input();


static int help_macro(helpline,subjtoken,command)
char *helpline;
char *subjtoken;	/* NULL for plain HELP/APUA/.. command */
char *command;	/* HELP,APUA,.. cmd used to get help.. */
{
	register char *s;
	int retval = 1;

	if (*helpline == '!')
	  ++helpline, retval = 0;
	s = helpline;
	if (*s == ' ' || *s == '\t' || *s == '\n' || *s == 0) 
	  return 0;	/* No match as macro.. */
	s = strchr(helpline,'\n');
	if (s) *s = 0;
	while (helpline && *helpline) {
	  s = strchr(helpline,'|');
	  if (s) *s++ = 0;
/*printf("help_macro() match `%s' and `%s' against `%s'\n",subjtoken,command,helpline);*/
	  if (strcmp(helpline,"*")==0) return retval; /* MATCH ALWAYS! */
	  if (subjtoken)
	    if (strcmp(subjtoken,helpline)==0) return retval;	/* MATCH! */
	  if (strcmp(command,helpline)==0) return retval;	/* MATCH! */
	  helpline = s;
	}
	return !retval;	/* No match.. */
}


int
do_help(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	FILE *fd;
	char filepath[512];
	char line[512];
	char *nextarg;
	char *fp;
	char item[80], fileinfo[512];
	int rc;
	int plusminus = 1;

	strcpy( filepath,TRICKLE_HOME );
	fp = filepath + strlen(filepath);

	if (*argstr == 0) {		/* bare APUA/HELP command.. */
	  strcpy( fp,"/help/HELP" );
	  fd = fopen(filepath,"r");
	  if (fd == NULL) {
	    fprintf(outfile,"Can't open `%s' -file! Bug ?\n",filepath);
	    return 0;
	  }
	  plusminus = 1;
	  while (!feof(fd) && !ferror(fd)) {
	    *line = 0;
	    if ( fgets( line,sizeof line,fd )==NULL ) break;
	    if (*line == 0) break;
	    if (*line == '+') {
	      if (help_macro(line+1,NULL,Cmd->name))
		++plusminus;
	    } else if (*line == '-') {
	      if (help_macro(line+1,NULL,Cmd->name))
		--plusminus;
	    } else if (*line == '=') {
	      plusminus = 0;
	      sscanf(line+1,"%d",&plusminus);
	    } else
	      if (plusminus > 0)
		fputs( line,outfile );
	  }
	  fclose(fd);
	  return 0;
	}

	strcpy( fp,"/help/HELPINDEX" );
	fd = fopen(filepath,"r");
	if (!fd) {
	  fprintf(outfile,"-- ERROR: Can't open `%s' to search known help items\n",filepath);
	  fprintf(outfile,"-- REPORT THIS TO MAINTANCE !\n");
	  return 1;
	}

	/* Parse this token... */
	nextarg = pick_nextarg(argstr);

	upperstr(argstr);

	plusminus = 1;
	while (!feof(fd) && !ferror(fd)) {
	  *line = 0;
	  if (fgets(line,sizeof line,fd) == NULL) break;
	  if (*line == 0) break;
	  if (*line == '#' || *line == '*' ||
	      *line == ';' || *line == '\n') continue;
	  if (*line == '+') {
	    if (help_macro(line+1,NULL,Cmd->name))
	      ++plusminus;
	    continue;
	  } else if (*line == '-') {
	    if (help_macro(line+1,NULL,Cmd->name))
	      --plusminus;
	    continue;
	  } else if (*line == '=') {
	    plusminus = 0;
	    sscanf(line+1,"%d",&plusminus);
	    continue;
	  } else if (plusminus <= 0) continue;
	  rc = sscanf(line,"%s %s",item,fileinfo);
	  if (rc != 2) continue;
	  if (strcasecmp(item,argstr)==0) {
	    /* Found item... */
	    if (*fileinfo == '/') /* absolute path */
	      strcpy(filepath,fileinfo);
	    else {
	      strcpy(fp,"/help/");
	      strcpy(fp+6,      fileinfo);
	    }
	    fclose(fd);		/* Found topic, close HELPINDEX! */

	    /* Start displaying that HELP file! */

	    fd = fopen(filepath,"r");
	    if (fd == NULL) {
	      fprintf(outfile,"--BUG ?  Can't open HELP item file `%s'\n",filepath);
	      return 0;
	    }
	    plusminus = 1;
	    while (!feof(fd) && !ferror(fd)) {
	      *line = 0;
	      if ( fgets( line,sizeof line,fd )==NULL ) break;
	      if (*line == 0) break;
	      if (*line == '+') {
		if (help_macro(line+1,argstr,Cmd->name))
		  ++plusminus;
	      } else if (*line == '-') {
		if (help_macro(line+1,argstr,Cmd->name))
		  --plusminus;
	      } else if (*line == '=') {
	        plusminus = 0;
	        sscanf(line+1,"%d",&plusminus);
	      } else
		if (plusminus > 0)
		  fputs( line,outfile );
	    }
	    fclose(fd);
	    return 0;
	  }
	  /* Hmm, not yet found asked topic, lets try other one */
	}
	/* Expired them all, bad luck... */

	fprintf(outfile,"Topic `%s' not found on HELP database.\n",argstr);
	if (fd)
	  fclose(fd);
	return 1;
}

int
do_pdget(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"Command `%s' not yet implemented.\n",Cmd->name);
	return 3;
}


int
do_pddir(Cmd, argstr, Hdr, outfile)
struct command *Cmd;
char *argstr;
struct headers *Hdr;
FILE *outfile;
{
	fprintf(outfile,"Command `%s' not yet implemented.\n",Cmd->name);
	return 3;
}
