/* AccessLogging.c */


#include <sys/types.h>
#ifdef	USG
#include <sys/bsdtypes.h>
#include <dirent.h>
#define direct dirent	/* cultural differences */
#include <net/errno.h>
#define NBBY 8		/* Dangerous!  Do it only if byte has 8 bits! */
#define	index	strchr
#define rindex	strrchr
#endif
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <fcntl.h>
#ifndef	USG
#include <sys/wait.h>
#include <sys/dir.h>
#endif

#include <ctype.h>
#include <stdio.h>
#include <signal.h>
#include <pwd.h>
#include <setjmp.h>
#include <netdb.h>
#include <errno.h>
#include <strings.h>
#include <syslog.h>
#include <varargs.h>

/*
 * Collection place of log file (not via SYSLOG which is unreliable.)
 */
#define ACCESSLOG	"/usr/adm/ftpd.log"


static int LoggingFD = -1;

void
SetupLogging()
{
  LoggingFD = open( ACCESSLOG, O_WRONLY|O_APPEND|O_CREAT, 0664 );
}


void
AccessLogging( va_alist )
     va_dcl
{
  va_list ap;
  int len;
  char *fmt;
  char buf[1024];

  if (LoggingFD < 0) return;
  va_start (ap);
  fmt = va_arg(ap, char *);
  vsprintf(buf,fmt,ap);
  va_end (ap);
  len = strlen(buf);
  strcat( buf+len,"\n" );

  write( LoggingFD,buf,len+1 );
}
