


object(3)              C LIBRARY FUNCTIONS              object(3)



_________________________________________________________________

NAME
     objectCreateProc, objectExists, objectFree, objectConfigure
     objectSlot, objectSlotSet, objectSlotAppend, objectSlots
       - object manipulation using Tcl scripting

SYNOPSIS
     objectCreateProc _c_l_a_s_s _o_b_j_e_c_t

     objectExists _o_b_j_e_c_t
     objectSlots _o_b_j_e_c_t
     objectFree _o_b_j_e_c_t

     objectSlot _o_b_j_e_c_t _s_l_o_t
     objectSlotSet _o_b_j_e_c_t _s_l_o_t _v_a_l_u_e
     objectSlotAppend _o_b_j_e_c_t _s_l_o_t _v_a_l_u_e

     objectConfigure _c_l_a_s_s _o_b_j_e_c_t _o_p_t_i_o_n_s
_________________________________________________________________

DESCRIPTION
     A procedural object is a Tcl procedure  that  represents  an
     object.   The  utility  commands  described in this man page
     allow one to easily implement procedural objects  using  Tcl
     scripting only.

     A procedural object is usually implemented in C (e.g., as  a
     C  struct)  for  speed  but has a Tcl access interface.  For
     example, Tk implements its widget classes in C but  provides
     Tcl interfaces to access those widgets.  Tk uses a procedure
     to represent each widget instance.

     The first argument of one of these procedural objects  is  a
     method selector.  In other words, if _o_b_j_e_c_t is the name of a
     procedural object:

     _o_b_j_e_c_t _m_e_t_h_o_d ?_a_r_g_s ...?

     If you use the utility procedures described in this man page
     to  implement  a  procedural object, that object will have a
     class and may have slots.  The class of  the  object  deter-
     mines  what  methods  the  object will respond to.  No class
     inheritance is supported.

COMMANDS
     objectCreateProc _c_l_a_s_s _o_b_j_e_c_t

          This command creates a new Tcl procedure to represent a
          new  _o_b_j_e_c_t.   The  new  procedure  will  have the name
          _o_b_j_e_c_t and have the given _c_l_a_s_s.




Sun Release 4.1           Last change:                          1






object(3)              C LIBRARY FUNCTIONS              object(3)



     objectExists _o_b_j_e_c_t

          This command returns 1 if  a  procedural  object  named
          _o_b_j_e_c_t  exists  in the interpreter and returns 0 other-
          wise.

     objectFree _o_b_j_e_c_t

          This command frees up the resources associated with the
          _o_b_j_e_c_t,   which   should   have   been   created   with
          objectCreateProc.  After using objectFree on an _o_b_j_e_c_t,
          no  more  references to that _o_b_j_e_c_t or its slots should
          be made.

     objectSlots _o_b_j_e_c_t

          This command returns a list of the slots  of  the  pro-
          cedural  _o_b_j_e_c_t,  which  should  have been created with
          objectCreateProc.

     objectSlot _o_b_j_e_c_t _s_l_o_t

          This command returns the value of a _s_l_o_t  of  the  pro-
          cedural  _o_b_j_e_c_t,  which  should  have been created with
          objectCreateProc.

     objectSlotSet _o_b_j_e_c_t _s_l_o_t _v_a_l_u_e

          This command sets the _v_a_l_u_e of a _s_l_o_t  of  the  _o_b_j_e_c_t,
          which  should  have been created with objectCreateProc.
          If _s_l_o_t is not yet a slot of the _o_b_j_e_c_t,  this  command
          will  make  _s_l_o_t a slot of the object.  Thus, slots can
          be  dynamically  added   to   objects   created   using
          objectCreateProc.  A _s_l_o_t may not be an array.

     objectSlotAppend _o_b_j_e_c_t _s_l_o_t _v_a_l_u_e

          This command uses lappend to append the given _v_a_l_u_e  to
          the  current  value  of  the  _s_l_o_t of the _o_b_j_e_c_t, which
          should have been  created  with  objectCreateProc.   If
          _s_l_o_t is not yet a slot of the _o_b_j_e_c_t, this command will
          make _s_l_o_t a slot of the object.   Thus,  slots  can  be
          dynamically    added    to    objects   created   using
          objectCreateProc.

     objectConfigure _c_l_a_s_s _o_b_j_e_c_t ?_o_p_t_i_o_n_s?

          This command provides a Tk "configure"  style  of  slot
          access  for  the  procedural  _o_b_j_e_c_t, which should have
          been  created  using  objectCreateProc.   (See  example
          usage  below.)   The argument _c_l_a_s_s should be the class
          of the _o_b_j_e_c_t.  The optional _o_p_t_i_o_n_s  argument  can  be



Sun Release 4.1           Last change:                          2






object(3)              C LIBRARY FUNCTIONS              object(3)



          used in the following three formats:

          objectConfigure _c_l_a_s_s _o_b_j_e_c_t ?-_s_l_o_t?
          objectConfigure _c_l_a_s_s _o_b_j_e_c_t ?-_s_l_o_t _v_a_l -_s_l_o_t _v_a_l ...?
          objectConfigure _c_l_a_s_s _o_b_j_e_c_t

          The first format of objectConfigure retrieves the  con-
          figuration  entry  for  a  given _s_l_o_t.  A configuration
          entry for a _s_l_o_t is a triplet of the format  of  {-_s_l_o_t
          _d_e_f_a_u_l_t  _v_a_l_u_e}, where -_s_l_o_t is the slot name prepended
          with a hyphen, _d_e_f_a_u_l_t is the  default  value  for  the
          _s_l_o_t,  and  _v_a_l_u_e  is  the  current  value of the _s_l_o_t.
          (Note that this configuration entry format for slots is
          different  than  the  configuration  entry format of Tk
          widget options.)

          The second format of objectConfigure sets  the  current
          values of several _s_l_o_ts of an _o_b_j_e_c_t.

          The third format of objectConfigure retrieves the  con-
          figuration entries of all the slots of the _o_b_j_e_c_t.

          Note that to use objectConfigure, you  must  prepend  a
          hyphen  ('-') to each slot name.  (e.g., "slot" becomes
          "-slot".)  This was designed  for  pseudo-compatability
          with the Tk style of widget option configuration, since
          widget options in Tk  are  all  prefixed  with  a  '-'.
          Also,  any  slot names, _s_l_o_t, should be fully specified
          and not abbreviated.

CLASSES AND METHODS
     The command objectCreateProc creates  a  new  Tcl  procedure
     whose  name  is _o_b_j_e_c_t to represent a new procedural object.
     You may invoke various methods  on  the  procedural  _o_b_j_e_c_t,
     using the following general form:

          _o_b_j_e_c_t _m_e_t_h_o_d ?_a_r_g_0 _a_r_g_1 ...?


     The _m_e_t_h_o_d argument and the _c_l_a_s_s of  the  _o_b_j_e_c_t  determine
     the method invoked.

     Methods for classes are specified using the following form:

          proc _c_l_a_s_s._m_e_t_h_o_d {_s_e_l_f _a_r_g_0 ... _a_r_g_N} {
             ...method body...
          }

     The first argument _s_e_l_f is required in the method specifica-
     tion.   The  _s_e_l_f  argument is set to the name of the _o_b_j_e_c_t
     that the _m_e_t_h_o_d will get called upon.




Sun Release 4.1           Last change:                          3






object(3)              C LIBRARY FUNCTIONS              object(3)



EXAMPLE
     The following is a simple example of using  the  above  com-
     mands  to  create  a  procedural  object using Tcl scripting
     only:

          # Define point creator.
          #
          proc makePoint {aPoint} {
             objectCreateProc point $aPoint;
             objectSlotSet $aPoint x 0;
             objectSlotSet $aPoint y 0;
             return $aPoint;
          }

          # Define methods of point class.
          #
          proc point.configure {aPoint args} {
             return [eval objectConfigure point $aPoint $args];
          }

          proc point.slot-value {aPoint slot} {
            return [objectSlot $aPoint $slot];
          }

          proc point.draw {aPoint} {
             set x [objectSlot $aPoint x];
             set y [objectSlot $aPoint y];
             dot $x $y;
          }

          # Instatiate a point and test it out.
          #
          makePoint p;
          p configure -x 10 -y 20;
          p configure -x;
          p configure;
          p slot-value x;
          p draw;
          objectExists p;
          objectFree p;


KEYWORDS
     object, method, class, slots, associative arrays, configure,
     options, prototyping

AUTHOR
     Brian Smith (bsmith@cs.berkeley.edu)
     Steve Yen (syen@cs.berkeley.edu)






Sun Release 4.1           Last change:                          4



