#
# Registrar
# ---------
# 
# This program is the central Registrar for Tcl GroupKit applications.  The
# Registrar maintains a list of all active conferences and their users.  
# The Registrar accepts connections from Registrar Client programs that
# manipulate the lists.  
#
# The Registrar is an example of a "controlled object" in an open protocol.
# It provides a set of operations (protocol) whereby people can manipulate
# the lists, but does so without any policy of how the lists should be
# manipulated.  Registrar Clients (the "controller objects") use the protocol
# to implement specific policies.
#
# The Registrar should be run on a well-known machine at a well-known
# port, in order that the Registrar Clients can locate and connect to it
# (see the file rc.tcl).
#
# While it is possible to start up a number of different Registrars,
# typically only a single one is active.  
#

initGkErrorHandling

catch {source ~/.tclgkrc}

foreach i $argv { 
    if {[string range $i 0 1] == "-p"} {
	set regportnum [string range $i 2 [expr [string length $i]-1]]
    }
}

if {[info exists regportnum] == 0} {
    set regportnum 9068
}


#
# create our server so people can connect to us; change this port if desired
#

MakeRPCServer $regportnum


#
# list of conferences; this is actually a list of keyed lists
#

set confs ""

#
# counter; we use this so that all conferences and users are assigned a 
#    unique id number (confnum and usernum respectively) which is used to
#    identify them in the system
#

set myID 0
proc newid {} {   global myID
	incr myID
	return $myID
}


#
# create a new conference;  the parameter is a keyed list containing 
#    information about the conference;  we add to this information a 
#    unique id number
# 

proc new_conference conf {	global confs
	keylset conf confnum [newid]
	lappend confs $conf
}


#
# delete a conference given its id number
#

proc delete_conference id {	global confs
	set posn [lsearch $confs "*\{confnum $id\}*"]
	if {$posn != -1} { set confs [lreplace $confs $posn $posn] }
}


#
# send the list of conferences to all of our connected registrar clients.
# no changes to the conference list (from the previous two routines) are
# broadcast until this routine is called
#

proc disp_conference {} {	global confs connections
	foreach i $connections { RDO $i conflist $confs }
}


#
# add a user to a particular conference.  the user parameter is a keyed
#    list containing information about the user; we append to this a unique
#    id number for this user.  additionally, the parameter must include
#    a 'confnum' key specifying the conference to join
#

proc add_user user {	global users
	keylset user usernum [newid]
	lappend users([keylget user confnum]) $user
}


#
# delete a user given a conference and user number
#

proc delete_user {conf user} {    global users
    set posn [lsearch $users($conf) "*\{usernum $user\}*"]
    if {$posn != -1} { set users($conf) [lreplace $users($conf) $posn $posn] }
}


# 
# send the list of users of the given conference to all connected registrar
#    clients.  no changes to the list (from the previous two routines) are
#    broadcast until this routine is called
#

proc disp_users {conf} {	global users connections
	foreach i $connections { RDO $i userlist $conf $users($conf) }
}

wm withdraw .

