#!/usr/local/bin/wish -f

# Init the TIX package
lappend auto_path ../library
tixInit -libdir ../library -scheme SGIGray -fontset 14Point -binding Motif

source tr_dialog.tcl
source tr_filebox.tcl
source tr_combo.tcl
source tr_misc.tcl
source tr_popup.tcl
source tr_about.tcl

proc MkMainWindow {w} {
    wm withdraw .
    toplevel $w
    wm minsize $w 0 0
    wm geometry $w 530x300

    set frame1 [MkMainMenu $w]
    set frame2 [MkMainBar $w]
    set frame3 [MkMainText $w]

    pack $frame1 $frame2 -side top -fill x
    pack $frame3 -side bottom -expand yes -fill both
}

proc MkMainMenu {top} {
    set w [frame $top.f1 -bd 1 -relief raised]

    button $w.fil -text "Filebox"   -command MkFileDialog1
    button $w.com -text "Combobox"  -command MkComboDialog
    button $w.pop -text "PopupMenu" -command MkPopDialog1
    button $w.dlg -text "Dialogs"   -command MkDialogDialog1
    button $w.msc -text "Misc"      -command MkMiscDialog
    button $w.qui -text "Quit"      -command exit
    button $w.abt -text "About"     -command MkAboutDialog1

    pack $w.fil $w.com $w.pop $w.dlg $w.msc -side left -padx 4 -pady 4
    pack $w.qui $w.abt -side right -padx 4 -pady 4

    return $w
}

proc MkMainBar {top} {
    set w [frame $top.f2 -bd 1 -relief raised]

    tixCombobox $w.cbx1 -width 15 -height 3 -command "MainTextFont $top"
    tixCombobox $w.cbx2 -width 4  -height 3 -command "MainTextFont $top"

    pack $w.cbx1 $w.cbx2 -side left -padx 4 -pady 4

    $w.cbx1 appendhistory "Courier"
    $w.cbx1 appendhistory "Helvetica"
    $w.cbx1 appendhistory "Lucida"
    $w.cbx1 appendhistory "Times Roman"

    $w.cbx2 appendhistory 8
    $w.cbx2 appendhistory 10
    $w.cbx2 appendhistory 12
    $w.cbx2 appendhistory 14
    $w.cbx2 appendhistory 18

    $w.cbx1 pick -index 1
    $w.cbx2 pick -index 3

    return $w
}

proc MkMainText {top} {
    set w [frame $top.f3 -bd 1 -relief raised]
    message $w.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*\
	-relief sunken -bd 1 -width 400 -anchor n\
	-text {


Welcome to TIX version 3.6

TIX 3.6 is a set of compound widgets based on TK. This program \
demostrates all the widgets in the TIX widget. You can press \
the buttons in this window to look at the corresponding widgets. \
To quit this program, press the "Quit" button.
}

    pack $w.msg -expand yes -fill both -padx 10 -pady 10
    return $w
}

proc MainTextFont {w args} {
    set font  [$w.f2.cbx1 get]
    set point [$w.f2.cbx2 get]

    case $font {
	"Courier" {
	    set f courier
	}
	"Helvetica" {
	    set f helvetica
	}
	"Lucida" {
	    set f lucida
	}
	default {
	    set f times
	}
    }

    set xfont [format "-*-%s-bold-r-normal-*-%s-*-*-*-*-*-*-*" $f $point]
    catch {
	$w.f3.msg config -font $xfont
    }

}

MkMainWindow .tour
