/*
 *	$Source: /user/nlfm/Working/Frink/RCS/frink.c,v $
 *	$Date: 1994/09/29 15:08:56 $
 *	$Revision: 1.2.1.5 $
 *
 *------------------------------------------------------------------------
 *   AUTHOR:  Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
 *------------------------------------------------------------------------
 *    Copyright 1994 The University of Newcastle upon Tyne (see COPYRIGHT)
 *========================================================================
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "frink.h"

int lmargin	= 0;
int addSpaces	= 0;
int width	= 80;
int indent	= 4;
int contdent	= 2;
int nocomments	= 0;
int obfuscate	= 0;
int tabsOn	= 1;
int putElse	= 0;
int tabStops	= 8;
int minimise	= 0;
int xf		= 0;
int oneliner	= 0;
int doBind	= 1;
int debrace	= 0;
int embrace	= 0;
int trace	= 0;
int varbrace	= 0;
int noblanks	= 0;
int procnls	= 0;
char *style	= (char *) 0;
char *pstyle	= (char *) 0;
char *contString 	= "";

extern int getopt(int, char**, char*);
extern int optind;
extern char *optarg;
extern int fclose(FILE*);

static void usage()
{
    fprintf(stderr, "frink [flags] [files] where the flags can be"
	    "\n"
	    "\n-a 	: put spaces around -command code in {} and \"\". (default = OFF)"
	    "\n-b 	: add braces (see manual page for details) (default = OFF)"
	    "\n-c <n>	: set further indent for continuations to n. default = 2"
	    "\n-d	: remove braces in certain (safe) circumstances (default = OFF)"
	    "\n-e	: produce \"else\". default = OFF"
	    "\n-h	: print this message."
	    "\n-i <n>	: set indent for each level to n. default = 4"
	    "\n-j	: remove non-essential blank lines. (default = OFF)"
	    "\n-k	: remove non-essential braces."
	    "\n-l	: try for one-liners (not yet implemented)"
	    "\n-m	: minimise the code by removing redundant spacing. default = OFF"
	    "\n-n 	: do not generate tab characters. default = OFF"
	    "\n-o	: obfuscate (not implemented yet) : default = OFF"
	    "\n-p <v>	: If v is a number produce that many blank lines after each"
	    "\n	proc definition, otherwise produce whatever format the code"
	    "\n	indicates. No codes are defined yet..... (default = do nothing)"
	    "\n-r	: remove comments. default = OFF"
	    "\n-s <c>	: format according to style \"c:\""
	    "\n-t <n>	: set tabstops every n characters. default = 8"
	    "\n-v	: put { } round variable names here appropriate."
	    "\n-w <n>	: set line length. default = 80"
	    "\n-x	: produce \"xf style\" continuations"
	    "\n-z	: do not put a single space before the \\ character on continuations."
	    "\n");
}

void setOption(int flag, char *value)
{
    switch (flag)
    {
    case 'D' :	trace = 1; break;
    case 'a' :	addSpaces = 1; break;
    case 'b' :	embrace = 1; debrace = 0; break;
    case 'c' :	contdent = atoi(value); break;
    case 'd' :	debrace = 1; embrace = 0; break;
    case 'e' :	putElse = 1; break;
    case 'i' :	indent = atoi(value); break;
    case 'j' :	noblanks = 1; break;
    case 'k' :	debrace = 1; break;
    case 'l' :	oneliner = 1; break;
    case 'm' :	minimise = 1; break;
    case 'n' :	tabsOn = 0; break;
    case 'o' :	obfuscate = 1; break;
    case 'p' :
	if (isdigit(*value))
	{
	    procnls = atoi(value);
	}
	else
	{
	    pstyle = optarg;
	}
	break;
    case 'r' :	nocomments = 1; break;
    case 's' :	style = value; break;
    case 't' :	tabStops = atoi(value); break;
    case 'v' :	varbrace = 1; break;
    case 'w' :	width = atoi(value); break;
    case 'x' :	xf = 1; break;
    case 'z' :	contString = " "; break;
    case 'h' :
    default :	usage(); exit(1);
    }
}

static void options(int argc, char *argv[])
{
    int flag;

    while ((flag = getopt(argc, argv ,"Dabc:dehi:jklmnoprs:t:vw:xz")) != -1)
    {
	setOption(flag, optarg);
    }
}

static void setStyle()
{
    if (style != (char *) 0)
    {
/*
 * None defined as yet
 */
    }
    if (obfuscate || minimise)
    {
	minimise = 1;
	debrace = 1;
	embrace = 0;
	noblanks = 1;
	nocomments = 1;
    }
}

static void readrc(char *file)
{
    char *opts[50], buff[128], *cp;
    FILE *desc;
    int leng, i;

    if ((desc = fopen("./.frinkrc", "r")) != NULL)
    {
	leng = fread(buff, 1, 127, desc);
	fclose(desc);
	buff[leng] = '\0';
	cp = buff;
	opts[0] = "";
	leng = 1;
	while (*cp)
	{
	    while (isspace(*cp)) { cp++; }
	    opts[leng++] = cp;
	    while (*cp && !isspace(*cp)) { cp++; }
	    if (*cp) { *cp++ = '\0'; }
	}
	for (i = 0; i < leng; i += 1)
	{
	    if (*opts[i] == '-')
	    {
		setOption(opts[i][1], opts[i+1]);
	    }
	}
    }
}

static void findrc()
{
    char *home, file[512];
    if ((home = getenv("HOME")) != (char *) 0)
    {
	strcat(strcpy(file, home),"/.frinkrc");
	readrc(file);
    }
    readrc("./.frinkrc");
}

static void process(FILE *desc)
{
    extern void flushOutput();
    extern int handle (Token *line);
    extern void streamMore(Input *);

    Input file;
    file.text = (char *) malloc(64*1024);
    file.stream = desc;
    file.tcall = 0;
    streamMore(&file);
    while (handle(collect(&file)))
    {
    }
    flushOutput();
}


int main(int argc, char **argv)
{
    FILE  *desc;

    findrc();
    options(argc, argv);
    setStyle();
    if (argv[optind] == (char *) 0)
    {
	process(stdin);
    }
    else
    {
	while (argv[optind] != (char *) 0)
	{
	    if ((desc = fopen(argv[optind], "r")) == NULL)
	    {
		fprintf(stderr, "\"%s\" annot be accessed!!\n", argv[optind]);
	    }
	    else
	    {
		process(desc);
		fclose(desc);
	    }
	    optind += 1;
	}
    }
    return 0;
}
