/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class DelayedRunnable
implements Delayed,
Runnable {
    final long timestamp;

    protected DelayedRunnable(long l) {
        this.timestamp = l;
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        return timeUnit.convert(this.timestamp - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed instanceof Immediate) {
            return 1;
        }
        return Long.signum(this.timestamp - ((DelayedRunnable)delayed).timestamp);
    }

    public static abstract class Immediate
    extends DelayedRunnable {
        private static final AtomicLong COUNTER = new AtomicLong(Long.MIN_VALUE);

        protected Immediate() {
            super(COUNTER.getAndIncrement());
        }

        @Override
        public final long getDelay(TimeUnit timeUnit) {
            return 0L;
        }

        @Override
        public final int compareTo(Delayed delayed) {
            if (delayed instanceof Immediate && this.timestamp > ((Immediate)delayed).timestamp) {
                return 1;
            }
            return -1;
        }
    }
}

