/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Collection<T> diff(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c1.isEmpty() || c2 == null || c2.size() == 0) {
            return c1;
        }
        ArrayList<T> difference = new ArrayList<T>();
        for (T item : c1) {
            if (c2.contains(item)) continue;
            difference.add(item);
        }
        return difference;
    }

    public static <T> boolean isEmpty(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return true;
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            if (iter.next() == null) continue;
            return false;
        }
        return true;
    }

    public static <S, T> Dictionary<S, T> singletonDictionary(S s, T t) {
        return CollectionUtils.toDictionary(Collections.singletonMap(s, t));
    }

    public static <S, T> Dictionary<S, T> toDictionary(Map<S, T> map) {
        return new MapToDictionary<S, T>(map);
    }

    static class MapToDictionary<S, T>
    extends Dictionary<S, T> {
        private Map<S, T> map;

        MapToDictionary(Map<S, T> map) {
            this.map = map;
        }

        @Override
        public Enumeration<T> elements() {
            if (this.map == null) {
                return null;
            }
            return new IteratorToEnumeration<T>(this.map.values().iterator());
        }

        @Override
        public T get(Object key) {
            if (this.map == null) {
                return null;
            }
            return this.map.get(key);
        }

        @Override
        public boolean isEmpty() {
            if (this.map == null) {
                return true;
            }
            return this.map.isEmpty();
        }

        @Override
        public Enumeration<S> keys() {
            if (this.map == null) {
                return null;
            }
            return new IteratorToEnumeration<S>(this.map.keySet().iterator());
        }

        @Override
        public T put(S key, T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public T remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            if (this.map == null) {
                return 0;
            }
            return this.map.size();
        }

        static class IteratorToEnumeration<X>
        implements Enumeration<X> {
            private final Iterator<X> iter;

            IteratorToEnumeration(Iterator<X> iter) {
                this.iter = iter;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.iter == null) {
                    return false;
                }
                return this.iter.hasNext();
            }

            @Override
            public X nextElement() {
                if (this.iter == null) {
                    return null;
                }
                return this.iter.next();
            }
        }
    }
}

