#!/usr/bin/perl

package eBay::API::XML::DataType::CalculatedShippingRateType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CalculatedShippingRateType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CalculatedShippingRateType

=head1 DESCRIPTION

Details pertinent to one or more items for which
calculated shipping has been offered by the seller, such as package
dimension and weight and packaging/handling costs. Also returned
with the data for an item's transaction.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CalculatedShippingRateType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::MeasureType;
use eBay::API::XML::DataType::Enum::MeasurementSystemCodeType;
use eBay::API::XML::DataType::Enum::ShippingPackageCodeType;


my @gaProperties = ( [ 'InternationalPackagingHandlingCosts', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MeasurementUnit', 'ns:MeasurementSystemCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::MeasurementSystemCodeType', '' ]
	, [ 'OriginatingPostalCode', 'xs:string', '', '', '' ]
	, [ 'PackageDepth', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PackageLength', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PackageWidth', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'PackagingHandlingCosts', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ShippingIrregular', 'xs:boolean', '', '', '' ]
	, [ 'ShippingPackage', 'ns:ShippingPackageCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ShippingPackageCodeType', '' ]
	, [ 'WeightMajor', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
	, [ 'WeightMinor', 'ns:MeasureType', ''
	     ,'eBay::API::XML::DataType::MeasureType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setInternationalPackagingHandlingCosts()

Fees a seller might assess for the shipping of the item (in addition to
whatever the shipping service might charge).
Any packaging/handling cost specified on input is added to each shipping
service on output.
If domestic and international calculated shipping is offered for an item and
if packaging/handling cost is specified only for domestic shipping, that cost
will be applied by eBay as the international packaging/handling cost. (To
specify a international packaging/handling cost, you must always specify a
domestic packaging/handling cost, even if it is 0.)
For international calculated shipping only.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setInternationalPackagingHandlingCosts {
  my $self = shift;
  $self->{'InternationalPackagingHandlingCosts'} = shift
}

=head2 getInternationalPackagingHandlingCosts()

  Calls: GetBidderList
         GetItemShipping
         GetSellerList
  Returned: Conditionally

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getInternationalPackagingHandlingCosts {
  my $self = shift;
  return $self->_getDataTypeInstance( 'InternationalPackagingHandlingCosts'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMeasurementUnit()

Specifies the unit type of the weight and dimensions of a
shipping package.
If MeasurementUnit is used, it overrides the system specified by measurementSystem.
If MeasurementUnit and measurementSystem are not specified, the following defaults
will be used:
<br><br>
English: US<br>
Metric: CA, CAFR, AU
<br><br>
CA and CAFR supports both English and Metric, while other sites
only support the site's default.
<br><br>
Use MeasurementUnit with weight and package dimensions.  For example,
to represent a 5 lbs 2 oz package:
<br>
&lt;MeasurementUnit&gt;English&lt;/MeasurementUnit&gt;
<br>
&lt;WeightMajor&gt;5&lt;/WeightMajor&gt;
<br>
&lt;WeightMinor&gt;2&lt;/WeightMinor&gt;

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PackageDetails
Title: Package Dimensions and Weight

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasurementSystemCodeType'

=cut

sub setMeasurementUnit {
  my $self = shift;
  $self->{'MeasurementUnit'} = shift
}

=head2 getMeasurementUnit()

#    Returns: 'ns:MeasurementSystemCodeType'

=cut

sub getMeasurementUnit {
  my $self = shift;
  return $self->{'MeasurementUnit'};
}


=head2 setOriginatingPostalCode()

Postal code for the location from which the package will be shipped.
Required for calculated shipping. Use Item.PostalCode to specify the
location of the item used for searches by location.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setOriginatingPostalCode {
  my $self = shift;
  $self->{'OriginatingPostalCode'} = shift
}

=head2 getOriginatingPostalCode()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:string'

=cut

sub getOriginatingPostalCode {
  my $self = shift;
  return $self->{'OriginatingPostalCode'};
}


=head2 setPackageDepth()

Depth of the package, in whole number of inches, needed to ship the item.
This is validated against the selected shipping service.
Upon mismatch, a message is returned, such as, "Package
dimensions exceeds maximum allowable limit for
service XXXXX," where XXXXX is the name of the shipping service.
For calculated shipping only. Only returned if the seller
specified the value for the item. (In many cases, the seller
only specifies the weight fields.)
<br><br>
Developer impact: UPS requires dimensions for any Ground packages that are 3
cubic feet or larger and for all air packages, if they are to provide correct
shipping cost. If package dimensions are not included for an item listed with
calculated shipping, the shipping cost returned will be an estimate based on
standard dimensions for the defined package type. eBay enforces a dimensions
requirement on listings so that buyers receive accurate calculated shipping
costs.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PackageDetails
Title: Package Dimensions and Weight

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasureType'

=cut

sub setPackageDepth {
  my $self = shift;
  $self->{'PackageDepth'} = shift
}

=head2 getPackageDepth()

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:MeasureType'

=cut

sub getPackageDepth {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageDepth'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPackageLength()

Length of the package, in whole number of inches, needed to ship the item.
Upon mismatch, a message is returned, such as, "Package
dimensions exceeds maximum allowable limit for
service XXXXX," where XXXXX is the name of the shipping service.
For calculated shipping only. Only returned if the seller
specified the value for the item. (In many cases, the seller
only specifies the weight fields.)

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PackageDetails
Title: Package Dimensions and Weight

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasureType'

=cut

sub setPackageLength {
  my $self = shift;
  $self->{'PackageLength'} = shift
}

=head2 getPackageLength()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:MeasureType'

=cut

sub getPackageLength {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageLength'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPackageWidth()

Width of the package, in whole number of inches, needed to ship the item.
Upon mismatch, a message is returned, such as, "Package
dimensions exceeds maximum allowable limit for
service XXXXX," where XXXXX is the name of the shipping service.
For calculated shipping only. Only returned if the seller
specified the value for the item. (In many cases, the seller
only specifies the weight fields.)

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=PackageDetails
Title: Package Dimensions and Weight

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasureType'

=cut

sub setPackageWidth {
  my $self = shift;
  $self->{'PackageWidth'} = shift
}

=head2 getPackageWidth()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription,
							ItemReturnAttributes, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:MeasureType'

=cut

sub getPackageWidth {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackageWidth'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setPackagingHandlingCosts()

Fees a seller might assess for the shipping of the item (in addition to
whatever the shipping service might charge).
Any packaging/handling cost specified on input is added to each shipping
service on output.
If domestic and international calculated shipping is offered for an item and
if packaging/handling cost is specified only for domestic shipping, that cost
will be applied by eBay as the international packaging/handling cost. (To
specify a international packaging/handling cost, you must always specify a
domestic packaging/handling cost, even if it is 0.) When UPS is one of the
shipping services offered by the seller, package dimensions are required on
list/relist/revise.
For calculated shipping only.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:AmountType'

=cut

sub setPackagingHandlingCosts {
  my $self = shift;
  $self->{'PackagingHandlingCosts'} = shift
}

=head2 getPackagingHandlingCosts()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:AmountType'

=cut

sub getPackagingHandlingCosts {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PackagingHandlingCosts'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setShippingIrregular()

Whether a package is irregular and therefore cannot go
through the stamping machine at the shipping service office and
thus requires special or fragile handling. For calculated
shipping only.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setShippingIrregular {
  my $self = shift;
  $self->{'ShippingIrregular'} = shift
}

=head2 isShippingIrregular()

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isShippingIrregular {
  my $self = shift;
  return $self->{'ShippingIrregular'};
}


=head2 setShippingPackage()

The nature of the package used to ship the item(s).
Required for calculated shipping only.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:ShippingPackageCodeType'

=cut

sub setShippingPackage {
  my $self = shift;
  $self->{'ShippingPackage'} = shift
}

=head2 getShippingPackage()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:ShippingPackageCodeType'

=cut

sub getShippingPackage {
  my $self = shift;
  return $self->{'ShippingPackage'};
}


=head2 setWeightMajor()

WeightMajor and WeightMinor are used to specify the weight of a
shipping package. Here is how you would represent a package
weight of 5 lbs 2 oz: &lt;WeightMajor unit="lbs"&gt;5&lt;/WeightMajor&gt;
&lt;WeightMinor unit="oz"&gt;2&lt;/WeightMinor&gt;
See http://www.ups.com for the maximum weight allowed by UPS.
Above this maximum, the shipping type becomes Freight, an option
that can only be selected via the eBay Web site and not via API.
The weight details are validated against the selected shipping service.
For calculated shipping only.  Required on input when calculated shipping is used.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasureType'

=cut

sub setWeightMajor {
  my $self = shift;
  $self->{'WeightMajor'} = shift
}

=head2 getWeightMajor()

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:MeasureType'

=cut

sub getWeightMajor {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WeightMajor'
		,'eBay::API::XML::DataType::MeasureType');
}


=head2 setWeightMinor()

See the definition of WeightMajor. For calculated shipping only.
Required on input when calculated shipping is used.

  Calls: AddItem
         GetItemRecommendations
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: Conditionally

#    Argument: 'ns:MeasureType'

=cut

sub setWeightMinor {
  my $self = shift;
  $self->{'WeightMinor'} = shift
}

=head2 getWeightMinor()

  Calls: GetBidderList
         GetItemShipping
  Returned: Conditionally

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'ns:MeasureType'

=cut

sub getWeightMinor {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WeightMinor'
		,'eBay::API::XML::DataType::MeasureType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
